package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.scene.control.Label;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

/**
 * Factory class providing the titles for the notice board menus.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class NoticeBoardMenuTitleProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public Label createTitle(ENoticeBoardType type, ICity city) {
        Label title = new Label();
        String s = "";
         switch (type) {
             case MESSAGE:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.messages", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CHURCH:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.church", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_NOTICE_BOARD:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.cityHallNoticeBoard", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_MAYORS_OFFICE:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.mayorsOffice", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_ALDERMAN_OFFICE:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.alderman", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_MEETINGROOM:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case LOANER:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case MARKET_PLACE:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.marketplace.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case SHIP_SELECTION:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.shipSelection.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case SHIPYARD:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.shipyard.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case TAVERN:
                 TavernState tavern = city.getCityState().getTavernState();
                 s = tavern.getName();
                 break;
             case TRADING:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.trading.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case TRADING_OFFICE:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.tradingOffice.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case GUILD:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.guild.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case ARMORY:
                 s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.armory.title", new Object[]{}, locale.getCurrentLocal());
                 break;
         }
        title.setText(s);
        title.getStyleClass().add("noticeBoardTitle");
        return title;
    }
}
