/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.javafx.control.ShipIcon;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.player.EPlayerColor;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.testutilities.JavaFXThreadingRule;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Point2D;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class ShipIconTest {
    @Rule
    public JavaFXThreadingRule javafxRule = new JavaFXThreadingRule();

    @Test
    public void shouldUpdateShipPositionInitialisation() {
        IShip vessel = (IShip)Mockito.mock(IShip.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        SelectiveCachableXMLImageLoader imageLoader = new SelectiveCachableXMLImageLoader("imageDefinitions.xml");
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.graphic.data");
        try {
            Field f = imageLoader.getClass().getDeclaredField("unmarshaller");
            f.setAccessible(true);
            f.set(imageLoader, bean);
            Method m = imageLoader.getClass().getDeclaredMethod("loadImageFile", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)imageLoader, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        BDDMockito.given((Object)vessel.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)vessel.getLocation()).willReturn((Object)new Point2D(47.0, 11.0));
        BDDMockito.given((Object)vessel.pirateFlagProperty()).willReturn((Object)new SimpleBooleanProperty(false));
        BDDMockito.given((Object)vessel.getShipType()).willReturn((Object)EShipType.COG);
        BDDMockito.given((Object)player.getColor()).willReturn((Object)EPlayerColor.BURGUNDY);
        ShipIcon shipIcon = new ShipIcon((INavigableVessel)vessel, player, (IDataImageLoader)imageLoader);
        Assert.assertEquals((double)15.0, (double)shipIcon.getLayoutX(), (double)0.001);
        Assert.assertEquals((double)-21.0, (double)shipIcon.getLayoutY(), (double)0.001);
    }
}

