/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardArmoryMenuProvider;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardArmoryMenuProviderTest {
    @Mock
    private ch.sahits.game.openpatrician.utilities.l10n.Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private ApplicationContext context;
    @Mock
    private DecoratedTextFactory textFactory;
    @InjectMocks
    private NoticeBoardArmoryMenuProvider menuProvider;

    @Test
    public void shouldHaveTwoEntriesForAlderman() {
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        ICity city = (ICity)Mockito.mock(ICity.class);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)player.getRank()).willReturn((Object)ESocialRank.ALDERMAN);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(proxy, ENoticeBoardType.ARMORY);
        Assert.assertEquals((long)2L, (long)entries.size());
    }

    @Test
    public void shouldHaveTwoEntriesForMayorInHometown() {
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        ICity city = (ICity)Mockito.mock(ICity.class);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)player.getRank()).willReturn((Object)ESocialRank.MAYOR);
        BDDMockito.given((Object)player.getHometown()).willReturn((Object)city);
        BDDMockito.given((Object)proxy.getCity()).willReturn((Object)city);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(proxy, ENoticeBoardType.ARMORY);
        Assert.assertEquals((long)2L, (long)entries.size());
    }

    @Test
    public void shouldHaveOneEntries() {
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        ICity city = (ICity)Mockito.mock(ICity.class);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)player.getRank()).willReturn((Object)ESocialRank.COUNCILMAN);
        BDDMockito.given((Object)player.getHometown()).willReturn((Object)city);
        BDDMockito.given((Object)proxy.getCity()).willReturn((Object)city);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(proxy, ENoticeBoardType.ARMORY);
        Assert.assertEquals((long)1L, (long)entries.size());
    }
}

