/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMenuTitleProvider;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.testutilities.JavaFXThreadingRule;
import java.util.Locale;
import javafx.scene.control.Label;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardMenuTitleProviderTest {
    @Rule
    public JavaFXThreadingRule jfxRule = new JavaFXThreadingRule();
    @Mock
    private ch.sahits.game.openpatrician.utilities.l10n.Locale locale;
    @Mock
    private MessageSource messageSource;
    @InjectMocks
    private NoticeBoardMenuTitleProvider titleProvider;

    @Before
    public void setup() {
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class))).willReturn((Object)"non empty string");
    }

    @Test
    public void shouldProvideTitleForAllNoticeBoardTypes() {
        ICity city = (ICity)Mockito.mock(ICity.class);
        TavernState tavern = (TavernState)Mockito.mock(TavernState.class);
        CityState cityState = (CityState)Mockito.mock(CityState.class);
        BDDMockito.given((Object)city.getCityState()).willReturn((Object)cityState);
        BDDMockito.given((Object)cityState.getTavernState()).willReturn((Object)tavern);
        BDDMockito.given((Object)tavern.getName()).willReturn((Object)"TavernName");
        for (ENoticeBoardType types : ENoticeBoardType.values()) {
            Label lbl = this.titleProvider.createTitle(types, city);
            Assert.assertFalse((boolean)lbl.getText().equals(""));
        }
    }
}

