/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.ECityState;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.javafx.IJavaFXApplicationThreadExecution;
import ch.sahits.game.openpatrician.utilities.javafx.JavaFXApplicationThreadExecution;
import java.util.Iterator;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;

@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityIcons
extends VBox {
    public static final String MISSING_WARE_ID = "missingWare";
    private static final String CITY_EVENT_ID = "cityEvent";
    private final CityState cityState;
    private IJavaFXApplicationThreadExecution threadExecution;
    private final IDataImageLoader imageLoader;

    public CityIcons(CityState cityState, IDataImageLoader imageLoader) {
        super(2.0);
        this.cityState = cityState;
        this.imageLoader = imageLoader;
        this.threadExecution = new JavaFXApplicationThreadExecution();
        this.updateMissingWare();
        this.updateCityEvent();
        cityState.longestMissingWaresBinding().addListener((observable, oldValue, newValue) -> this.updateMissingWare());
        cityState.cityEventProperty().addListener((observable, oldValue, newValue) -> this.updateCityEvent());
    }

    private void updateCityEvent() {
        this.threadExecution.execute(() -> {
            ObjectProperty cityEvent = this.cityState.cityEventProperty();
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                if (!child.getId().equals(CITY_EVENT_ID)) continue;
                iterator.remove();
                break;
            }
            if (cityEvent.get() != null) {
                Image iconImg = this.imageLoader.getImage("icons/32/" + this.getEventIconName((ECityState)cityEvent.get()));
                ImageView imgView = new ImageView(iconImg);
                this.getChildren().add((Object)imgView);
            }
        });
    }

    private void updateMissingWare() {
        this.threadExecution.execute(() -> {
            ObjectBinding missingWareeBinding = this.cityState.longestMissingWaresBinding();
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                if (!child.getId().equals(MISSING_WARE_ID)) continue;
                iterator.remove();
                break;
            }
            if (missingWareeBinding.get() != null) {
                if (this.cityState.famineBinding().get()) {
                    Image famine = this.imageLoader.getImage("icons/32/icon_famine");
                    ImageView famineView = new ImageView(famine);
                    famineView.setId(MISSING_WARE_ID);
                    this.getChildren().add(0, (Object)famineView);
                } else {
                    String wareIconName = "icons/32/" + this.getIconName((IWare)missingWareeBinding.get());
                    Image missingWare = this.imageLoader.getImage(wareIconName);
                    ImageView missingWareView = new ImageView(missingWare);
                    missingWareView.setId(MISSING_WARE_ID);
                    this.getChildren().add(0, (Object)missingWareView);
                }
            }
        });
    }

    private String getIconName(IWare ware) {
        switch ((EWare)ware) {
            case BEER: {
                return "icon_beer";
            }
            case BRICK: {
                return "icon_bricks";
            }
            case CLOTH: {
                return "icon_cloth";
            }
            case FISH: {
                return "icon_fish";
            }
            case FISH_OIL: {
                return "icon_fish_oil";
            }
            case FUR: {
                return "icon_fur";
            }
            case GRAIN: {
                return "icon_grain";
            }
            case HEMP: {
                return "icon_hemp";
            }
            case HONEY: {
                return "icon_honey";
            }
            case IRON: {
                return "icon_iron";
            }
            case IRONORE: {
                return "icon_iron_ore";
            }
            case LEATHER: {
                return "icon_leather";
            }
            case MEAT: {
                return "icon_meat";
            }
            case PITCH: {
                return "icon_pitch";
            }
            case POTTERY: {
                return "icon_pottery";
            }
            case SALT: {
                return "icon_salt";
            }
            case SPICE: {
                return "icon_spices";
            }
            case WINE: {
                return "icon_wine";
            }
            case WOOD: {
                return "icon_wood";
            }
            case WOOL: {
                return "icon_wool";
            }
        }
        throw new IllegalArgumentException("Unhandled ware: " + ware);
    }

    private String getEventIconName(ECityState state) {
        switch (state) {
            case SIEGE: {
                return "icon_siege";
            }
            case BLOCKADE: {
                return "icon_blockade";
            }
            case FROZEN_HARBOR: {
                return "icon_frozen";
            }
            case PLAGUE: {
                return "icon_plague";
            }
            case FIRE: {
                return "icon_fire";
            }
        }
        throw new IllegalArgumentException("Unhandled state: " + state);
    }
}

