/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.javafx.control.MoneyTransfer;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class MoneyTransferSkin
extends SkinBase<MoneyTransfer> {
    private final MoneyTransfer moneyTranfer;
    private final IDataImageLoader imageLoader;

    public MoneyTransferSkin(MoneyTransfer control, IDataImageLoader imageLoader) {
        super((Control)control);
        this.moneyTranfer = control;
        this.imageLoader = imageLoader;
        this.initialzeComponents();
    }

    private void initialzeComponents() {
        HBox selectionBox = new HBox(5.0);
        Label input = new Label();
        input.setId("transferLabel");
        input.textProperty().bind((ObservableValue)this.moneyTranfer.amountProperty().asString());
        Image img = this.imageLoader.getImage("icons/minusIcon");
        ImageView imgView = new ImageView(img);
        imgView.setId("minusIcon");
        imgView.setOnMouseReleased(e -> {
            int value = Integer.parseInt(input.getText());
            this.moneyTranfer.setAmount(Math.max(value - this.moneyTranfer.getStepSize(), 0));
        });
        selectionBox.getChildren().addAll((Object[])new Node[]{imgView, input});
        img = this.imageLoader.getImage("icons/coin_icon", 32.0, 32.0);
        imgView = new ImageView(img);
        selectionBox.getChildren().add((Object)imgView);
        img = this.imageLoader.getImage("icons/plusIcon");
        imgView = new ImageView(img);
        imgView.setId("plusIcon");
        selectionBox.getChildren().add((Object)imgView);
        imgView.setOnMouseReleased(e -> {
            int value = Integer.parseInt(input.getText());
            this.moneyTranfer.setAmount(Math.min(value + this.moneyTranfer.getStepSize(), this.moneyTranfer.getMaxTransfereable()));
        });
        this.getChildren().add((Object)selectionBox);
    }
}

