/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.OpenPatricianDialogInput;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class OpenPatricianDialogInputSkin
extends SkinBase<OpenPatricianDialogInput> {
    private DoubleProperty width = new SimpleDoubleProperty((Object)this, "width", 0.0);
    private DoubleProperty height = new SimpleDoubleProperty((Object)this, "height", 0.0);
    private TextSizingUtility sizing = new TextSizingUtility();
    private final TextField textField;

    public OpenPatricianDialogInputSkin(OpenPatricianDialogInput input) {
        super((Control)input);
        this.textField = new TextField(input.getText());
        this.calculateDimensions(input);
        input.fontProperty().addListener((observable, oldValue, newValue) -> this.calculateDimensions(input));
        this.textField.textProperty().bindBidirectional((Property)input.textProperty());
        this.textField.getStyleClass().add((Object)"openPatricianDialogInput");
        Rectangle background = new Rectangle();
        background.setHeight(this.height.doubleValue());
        background.setWidth(this.width.doubleValue());
        background.setFill((Paint)Color.rgb((int)150, (int)150, (int)150));
        background.heightProperty().bind((ObservableValue)this.height);
        background.widthProperty().bind((ObservableValue)this.width);
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{background, this.textField});
        Group group = new Group(new Node[]{stack});
        group.setManaged(false);
        this.getChildren().add((Object)group);
    }

    private void calculateDimensions(OpenPatricianDialogInput input) {
        Dimension2D dim = this.sizing.calculate(input.getSize(), input.getFont());
        this.width.set(dim.getWidth());
        this.height.set(dim.getHeight() + 10.0);
        this.textField.setMaxSize(this.width.doubleValue(), this.height.doubleValue());
    }
}

