/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.io.InputStream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianWoodenTextInputSkin
extends SkinBase<OpenPatricianWoodenTextInput> {
    private DoubleProperty width = new SimpleDoubleProperty((Object)this, "width", 0.0);
    private DoubleProperty height = new SimpleDoubleProperty((Object)this, "height", 0.0);
    private TextSizingUtility sizing = new TextSizingUtility();
    private final TextField textField;
    private final ImageView imgView;

    public OpenPatricianWoodenTextInputSkin(OpenPatricianWoodenTextInput input) {
        super((Control)input);
        this.textField = new TextField(input.getText());
        this.imgView = new ImageView();
        this.calculateDimensions(input);
        this.textField.textProperty().bindBidirectional((Property)input.textProperty());
        this.textField.getStyleClass().add((Object)"openPatricianWoodenTextInput");
        Insets padding = this.textField.getPadding();
        Insets newPadding = new Insets(0.0, padding.getRight(), 0.0, padding.getLeft());
        this.textField.setPadding(newPadding);
        input.sizeProperty().addListener((observable, oldValue, newValue) -> this.calculateDimensions(input));
        this.textField.heightProperty().addListener((observable, oldValue, newValue) -> {
            Dimension2D dim = this.sizing.calculate(input.getSize(), input.getFont());
            this.height.set(Math.max(dim.getHeight(), newValue.doubleValue()));
            this.setImage();
        });
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{this.imgView, this.textField});
        Group group = new Group(new Node[]{stack});
        group.setManaged(false);
        this.getChildren().add((Object)group);
    }

    private void calculateDimensions(OpenPatricianWoodenTextInput input) {
        Dimension2D dim = this.sizing.calculate(input.getSize(), input.getFont());
        double inputHeigth = this.textField.getHeight();
        this.width.set(dim.getWidth());
        this.height.set(Math.max(dim.getHeight(), inputHeigth));
        this.textField.setMaxSize(this.width.doubleValue(), this.height.doubleValue());
        this.setImage();
    }

    private void setImage() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("InputPlank.jpg");
        Image img1 = new Image(is, this.width.doubleValue(), this.height.doubleValue(), false, true);
        this.imgView.setImage(img1);
        this.imgView.setLayoutY(0.0);
    }
}

