/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.javafx.control.ShipIcon;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IGroupableVessel;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ClassCategory(value={EClassCategory.JAVAFX})
public class ShipIconSkin
extends SkinBase<ShipIcon> {
    private static final double ICON_SCALE = 0.5;
    private static final double SHIELD_Y_OFFSET = 5.0;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final IDataImageLoader imageLoader;
    private final ShipIcon control;
    private Image shipIcon;
    private ImageView shipIconView;
    private ImageView shield;
    private ImageView piratingIndicator;
    private Label shipGroupSize;

    public ShipIconSkin(ShipIcon control, IDataImageLoader imageLoader) {
        super((Control)control);
        this.imageLoader = imageLoader;
        this.control = control;
        this.initializeControl();
    }

    private void initializeControl() {
        Group g = new Group();
        INavigableVessel vessel = this.control.getVessel();
        this.shipIcon = this.getShipIcon(vessel);
        this.shipIconView = new ImageView(this.shipIcon);
        int directionFactor = this.control.isTravelingEast() ? -1 : 1;
        this.control.travelingEastProperty().addListener((observable, oldValue, newValue) -> {
            int dir = this.control.isTravelingEast() ? -1 : 1;
            this.shipIconView.setScaleX(0.5 * (double)dir);
        });
        this.shipIconView.setScaleX(0.5 * (double)directionFactor);
        this.shipIconView.setScaleY(0.5);
        this.shield = this.createShield(vessel);
        this.shipGroupSize = new Label();
        if (vessel instanceof IGroupableVessel) {
            IGroupableVessel group = (IGroupableVessel)vessel;
            this.shipGroupSize.setText(String.valueOf(group.getShips().size()));
            DoubleBinding relYOrigin = this.shieldYOffsetBinding().add(2);
            this.shipGroupSize.layoutYProperty().bind((ObservableValue)relYOrigin);
            this.shipGroupSize.layoutXProperty().bind((ObservableValue)this.shipIconView.layoutXProperty().add(4));
            Color shieldColor = this.getShieldBaseColor(vessel);
            Color textColor = this.calculateContrastColor(shieldColor);
            this.shipGroupSize.setTextFill((Paint)textColor);
        }
        this.piratingIndicator = this.createPirateIndicator();
        g.getChildren().addAll((Object[])new Node[]{this.shipIconView, this.shield, this.shipGroupSize});
        if (vessel.getOwner().equals(this.control.getPlayer()) && vessel.getPirateFlag()) {
            g.getChildren().add((Object)this.piratingIndicator);
        }
        vessel.pirateFlagProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (vessel.getOwner().equals(this.control.getPlayer())) {
                    g.getChildren().add((Object)this.piratingIndicator);
                } else {
                    this.updateOtherPlayerShield(g, vessel);
                }
            } else if (vessel.getOwner().equals(this.control.getPlayer())) {
                g.getChildren().remove((Object)this.piratingIndicator);
            } else {
                this.updateOtherPlayerShield(g, vessel);
            }
        });
        this.updateShipPosition();
        this.control.travelingEastProperty().addListener((observable, oldValue, newValue) -> this.updateShipPosition());
        this.control.scaleProperty().addListener((observable, oldValue, newValue) -> this.updateShipPosition());
        this.getChildren().add((Object)g);
    }

    private void updateOtherPlayerShield(Group g, INavigableVessel vessel) {
        g.getChildren().remove((Object)this.shield);
        this.shield = this.createShield(vessel);
        g.getChildren().add((Object)this.shield);
        Color shieldColor = this.getShieldBaseColor(vessel);
        Color textColor = this.calculateContrastColor(shieldColor);
        this.shipGroupSize.setTextFill((Paint)textColor);
    }

    private Color calculateContrastColor(Color color) {
        double b;
        double g;
        double r = color.getRed();
        double gray = r + (g = color.getGreen()) + (b = color.getBlue());
        if (gray > 0.7) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public void updateShipPosition() {
        INavigableVessel vessel = this.control.getVessel();
        Point2D location = vessel.getLocation();
        double x = location.getX() * this.control.scaleProperty().get();
        double y = location.getY() * this.control.scaleProperty().get();
        this.control.setLayoutX(x - this.shipIcon.getWidth() / 2.0);
        this.control.setLayoutY(y - this.shipIcon.getHeight() / 2.0);
        this.logger.trace("Update ship {} position to {},{} in view {},{}", (Object)vessel.getName(), (Object)vessel.getLocation().getX(), (Object)vessel.getLocation().getY(), (Object)this.control.getLayoutX(), (Object)this.control.getLayoutY());
    }

    private ImageView createShield(INavigableVessel vessel) {
        Image shieldImg = this.imageLoader.getImage("icons/Shield_" + this.getShieldColorName(vessel));
        ImageView imgView = new ImageView(shieldImg);
        imgView.setLayoutX(this.shipIconView.getLayoutX());
        DoubleBinding relYOrigin = this.shieldYOffsetBinding();
        imgView.layoutYProperty().bind((ObservableValue)relYOrigin);
        imgView.layoutXProperty().bind((ObservableValue)this.shipIconView.layoutXProperty());
        return imgView;
    }

    private String getShieldColorName(INavigableVessel vessel) {
        if (vessel.getOwner() instanceof IHumanPlayer) {
            return ((IHumanPlayer)vessel.getOwner()).getColor().name();
        }
        if (vessel.getOwner() instanceof ISeaPirate || !vessel.getOwner().equals(this.control.getPlayer()) && vessel.getPirateFlag()) {
            return "BLACK";
        }
        return "LIGHTGRAY";
    }

    private Color getShieldBaseColor(INavigableVessel vessel) {
        Color color = vessel.getOwner() instanceof IHumanPlayer ? ((IHumanPlayer)vessel.getOwner()).getColor().getColor() : (vessel.getOwner() instanceof ISeaPirate || !vessel.getOwner().equals(this.control.getPlayer()) && vessel.getPirateFlag() ? Color.BLACK : Color.LIGHTGRAY);
        return color;
    }

    private ImageView createPirateIndicator() {
        Image shieldImg = this.imageLoader.getImage("icons/pirateIndicator");
        ImageView imgView = new ImageView(shieldImg);
        DoubleBinding relYOrigin = this.shieldYOffsetBinding();
        imgView.layoutYProperty().bind((ObservableValue)relYOrigin);
        imgView.layoutXProperty().bind((ObservableValue)this.shipIconView.layoutXProperty());
        return imgView;
    }

    private DoubleBinding shieldYOffsetBinding() {
        return this.shipIconView.layoutYProperty().add(this.shipIcon.getHeight() * 0.5 - 0.5 * this.shipIcon.getHeight() * 0.5 + 5.0);
    }

    private Image getShipIcon(INavigableVessel vessel) {
        if (vessel instanceof IShip) {
            switch (((IShip)vessel).getShipType()) {
                case COG: {
                    return this.imageLoader.getImage("icons/64/cog_icon");
                }
                case CRAYER: {
                    return this.imageLoader.getImage("icons/64/crayer_icon");
                }
                case HOLK: {
                    return this.imageLoader.getImage("icons/64/holk_icon");
                }
                case SNAIKKA: {
                    return this.imageLoader.getImage("icons/64/schnikka_icon");
                }
            }
        } else {
            IConvoy convoy = (IConvoy)vessel;
            return this.getShipIcon((INavigableVessel)convoy.getOrlegShip());
        }
        return null;
    }
}

