/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.effects.transform;

import ch.sahits.game.openpatrician.javafx.effects.transform.Translation2D;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.shape.Polygon;

@ClassCategory(value={EClassCategory.TEST})
public class PolygonPerspectiveTransformation {
    private static final Translation2D ORIGIN_ORIGIN = new Translation2D(0.0, 0.0, 0.0, 0.0);
    @ObjectPropertyType(value=Translation2D.class)
    private final ObjectProperty<Translation2D> point1 = new SimpleObjectProperty((Object)this, "point-1", (Object)ORIGIN_ORIGIN);
    @ObjectPropertyType(value=Translation2D.class)
    private final ObjectProperty<Translation2D> point2 = new SimpleObjectProperty((Object)this, "point-2", (Object)ORIGIN_ORIGIN);
    @ObjectPropertyType(value=Translation2D.class)
    private final ObjectProperty<Translation2D> point3 = new SimpleObjectProperty((Object)this, "point-3", (Object)ORIGIN_ORIGIN);
    private double a11 = 1.0;
    private double a12 = 0.0;
    private double a21 = 0.0;
    private double a22 = 1.0;
    private double b1 = 0.0;
    private double b2 = 0.0;

    public PolygonPerspectiveTransformation() {
        this.point1.addListener((ChangeListener)new RecalculationEventListener());
        this.point2.addListener((ChangeListener)new RecalculationEventListener());
        this.point3.addListener((ChangeListener)new RecalculationEventListener());
    }

    private void calculate() {
        this.a12 = this.calculateA12();
        this.a11 = this.calculateA11();
        this.b1 = this.calculateB1();
        this.a22 = this.calculateA22();
        this.a21 = this.calculateA21();
        this.b2 = this.calculateB2();
    }

    private double calculateA12() {
        double y1 = ((Translation2D)this.point1.getValue()).getSource().getY();
        double y2 = ((Translation2D)this.point2.getValue()).getSource().getY();
        double y3 = ((Translation2D)this.point3.getValue()).getSource().getY();
        double x1 = ((Translation2D)this.point1.getValue()).getSource().getX();
        double x2 = ((Translation2D)this.point2.getValue()).getSource().getX();
        double x3 = ((Translation2D)this.point3.getValue()).getSource().getX();
        double x1d = ((Translation2D)this.point1.getValue()).getDestination().getX();
        double x2d = ((Translation2D)this.point2.getValue()).getDestination().getX();
        double x3d = ((Translation2D)this.point3.getValue()).getDestination().getX();
        double diff_x2_x1 = x2 - x1;
        double diff_x3_x1 = x3 - x1;
        double top = x3d - x1d + (x1d - x2d) * diff_x3_x1 / diff_x2_x1;
        double bottom = y3 - y1 - (y2 - y1) * diff_x3_x1 / diff_x2_x1;
        return top / bottom;
    }

    private double calculateA11() {
        double x1 = ((Translation2D)this.point1.getValue()).getSource().getX();
        double x2 = ((Translation2D)this.point2.getValue()).getSource().getX();
        double y1 = ((Translation2D)this.point1.getValue()).getSource().getY();
        double y2 = ((Translation2D)this.point2.getValue()).getSource().getY();
        double x1d = ((Translation2D)this.point1.getValue()).getDestination().getX();
        double x2d = ((Translation2D)this.point2.getValue()).getDestination().getX();
        double top = x2d - x1d - this.a12 * (y2 - y1);
        double bottom = x2 - x1;
        return top / bottom;
    }

    private double calculateB1() {
        double x1 = ((Translation2D)this.point1.getValue()).getSource().getX();
        double y1 = ((Translation2D)this.point1.getValue()).getSource().getY();
        double x1d = ((Translation2D)this.point1.getValue()).getDestination().getX();
        return x1d - this.a11 * x1 - this.a12 * y1;
    }

    private double calculateA22() {
        double y1 = ((Translation2D)this.point1.getValue()).getSource().getY();
        double y2 = ((Translation2D)this.point2.getValue()).getSource().getY();
        double y3 = ((Translation2D)this.point3.getValue()).getSource().getY();
        double x1 = ((Translation2D)this.point1.getValue()).getSource().getX();
        double x2 = ((Translation2D)this.point2.getValue()).getSource().getX();
        double x3 = ((Translation2D)this.point3.getValue()).getSource().getX();
        double y1d = ((Translation2D)this.point1.getValue()).getDestination().getY();
        double y2d = ((Translation2D)this.point2.getValue()).getDestination().getY();
        double y3d = ((Translation2D)this.point3.getValue()).getDestination().getY();
        double diff_x2_x1 = x2 - x1;
        double diff_x3_x1 = x3 - x1;
        double top = y3d - y1d - (y2d - y1d) * diff_x3_x1 / diff_x2_x1;
        double bottom = y3 - y1 - (y2 - y1) * diff_x3_x1 / diff_x2_x1;
        return top / bottom;
    }

    private double calculateA21() {
        double y1 = ((Translation2D)this.point1.getValue()).getSource().getY();
        double y2 = ((Translation2D)this.point2.getValue()).getSource().getY();
        double x1 = ((Translation2D)this.point1.getValue()).getSource().getX();
        double x2 = ((Translation2D)this.point2.getValue()).getSource().getX();
        double y1d = ((Translation2D)this.point1.getValue()).getDestination().getY();
        double y2d = ((Translation2D)this.point2.getValue()).getDestination().getY();
        double top = y2d - y1d - this.a22 * (y2 - y1);
        double bottom = x2 - x1;
        return top / bottom;
    }

    private double calculateB2() {
        double x1 = ((Translation2D)this.point1.getValue()).getSource().getX();
        double y1 = ((Translation2D)this.point1.getValue()).getSource().getY();
        double y1d = ((Translation2D)this.point1.getValue()).getDestination().getY();
        return y1d - this.a21 * x1 - this.a22 * y1;
    }

    public Polygon transform(Polygon polygon) {
        List<Point2D> points = this.convertToPoints((ObservableList<Double>)polygon.getPoints());
        Polygon transformedPolygon = new Polygon();
        for (Point2D p : points) {
            double xd = p.getX() * this.a11 + p.getY() * this.a12 + this.b1;
            double yd = p.getX() * this.a21 + p.getY() * this.a22 + this.b2;
            transformedPolygon.getPoints().addAll((Object[])new Double[]{xd, yd});
        }
        return transformedPolygon;
    }

    private List<Point2D> convertToPoints(ObservableList<Double> points) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        Iterator it = points.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            double y = (Double)it.next();
            list.add(new Point2D(x, y));
        }
        return list;
    }

    public Translation2D getPoint3() {
        return (Translation2D)this.point3.get();
    }

    public void setPoint3(Translation2D value) {
        this.point3.set((Object)value);
    }

    public ObjectProperty<Translation2D> point3Property() {
        return this.point3;
    }

    public Translation2D getPoint2() {
        return (Translation2D)this.point2.get();
    }

    public void setPoint2(Translation2D value) {
        this.point2.set((Object)value);
    }

    public ObjectProperty<Translation2D> point2Property() {
        return this.point2;
    }

    public Translation2D getPoint1() {
        return (Translation2D)this.point1.get();
    }

    public void setPoint1(Translation2D value) {
        this.point1.set((Object)value);
    }

    public ObjectProperty<Translation2D> point1Property() {
        return this.point1;
    }

    private class RecalculationEventListener
    implements ChangeListener<Translation2D> {
        private RecalculationEventListener() {
        }

        public void changed(ObservableValue<? extends Translation2D> ov, Translation2D t, Translation2D t1) {
            PolygonPerspectiveTransformation.this.calculate();
        }
    }
}

