/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.LinkedHashSet;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.control.Label;

@ClassCategory(value={EClassCategory.MODEL})
public class NoticeBoardMenu {
    private Label title;
    private final ENoticeBoardType type;
    private ObservableSet<NoticeBoardMenuEntry> menuEntries = FXCollections.observableSet(new LinkedHashSet());

    public NoticeBoardMenu(ENoticeBoardType type) {
        this.type = type;
    }

    public void setMenuEntries(LinkedHashSet<NoticeBoardMenuEntry> menuEntries) {
        this.menuEntries.clear();
        this.menuEntries.addAll(menuEntries);
    }

    public Set<NoticeBoardMenuEntry> getMenuEntries() {
        return this.menuEntries;
    }

    public ObservableSet<NoticeBoardMenuEntry> menuEntriesProperty() {
        return this.menuEntries;
    }

    public void disableAll() {
        for (NoticeBoardMenuEntry menuEntry : this.menuEntries) {
            menuEntry.disabledProperty().setValue(Boolean.valueOf(true));
        }
    }

    public void enableAll() {
        for (NoticeBoardMenuEntry menuEntry : this.menuEntries) {
            menuEntry.disabledProperty().setValue(Boolean.valueOf(false));
        }
    }

    public void deselctAll() {
        for (NoticeBoardMenuEntry menuEntry : this.menuEntries) {
            menuEntry.setSelected(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NoticeBoardMenu)) {
            return false;
        }
        NoticeBoardMenu that = (NoticeBoardMenu)o;
        if (this.getTitle() != null ? !this.getTitle().getText().equals(that.getTitle().getText()) : that.getTitle() != null) {
            return false;
        }
        return this.getType() == that.getType();
    }

    public int hashCode() {
        int result = this.getTitle() != null ? this.getTitle().hashCode() : 0;
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NoticeBoardMenu{title=" + this.title.getText() + ", type=" + (Object)((Object)this.type) + '}';
    }

    public Label getTitle() {
        return this.title;
    }

    public void setTitle(Label title) {
        this.title = title;
    }

    public ENoticeBoardType getType() {
        return this.type;
    }
}

