/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.javafx.model.ECellConstraint;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@ClassCategory(value={EClassCategory.MODEL})
public class TableRow
implements Iterable<ITableCell> {
    @ListType(value=ITableCell.class)
    private List<ITableCell> cells = new ArrayList<ITableCell>();
    @MapType(key=ITableCell.class, value=ECellConstraint.class)
    private Map<ITableCell, ECellConstraint> contraints = new HashMap<ITableCell, ECellConstraint>();
    private int heigth = 0;

    public ITableCell get(int index) {
        return this.cells.get(index);
    }

    public int size() {
        return this.cells.size();
    }

    public void add(ITableCell cell) {
        this.cells.add(cell);
    }

    public void add(ITableCell cell, ECellConstraint contraint) {
        this.add(cell);
        this.contraints.put(cell, contraint);
    }

    @Override
    public Iterator<ITableCell> iterator() {
        return this.cells.iterator();
    }

    public boolean hasConstraint(ITableCell cell) {
        return this.contraints.containsKey(cell);
    }

    public ECellConstraint getCellConstraint(ITableCell cell) {
        return this.contraints.get(cell);
    }

    public int getHeigth() {
        return this.heigth;
    }

    public void setHeigth(int heigth) {
        this.heigth = heigth;
    }
}

