/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TextEllipsisCalculator {
    private static final String ELLIPSIS = "...";
    @Autowired
    private TextSizingUtility sizing;

    public String calculateEllipsis(Font font, String text, double maxWidth) {
        double ellipsisWidth = this.sizing.calculate(ELLIPSIS, font).getWidth();
        int guessNbChars = Math.min(this.sizing.guessNumberOfCharacters(maxWidth - ellipsisWidth, font), text.length());
        String substr = guessNbChars == text.length() ? text.substring(0, guessNbChars) : text.substring(0, guessNbChars) + ELLIPSIS;
        boolean reducedNbCharacters = false;
        double currentCalculatedWidth = this.sizing.calculate(substr, font).getWidth();
        while (currentCalculatedWidth > maxWidth) {
            reducedNbCharacters = true;
            substr = text.substring(0, --guessNbChars) + ELLIPSIS;
            currentCalculatedWidth = this.sizing.calculate(substr, font).getWidth();
        }
        if (!reducedNbCharacters) {
            while (currentCalculatedWidth < maxWidth && guessNbChars < text.length()) {
                substr = ++guessNbChars == text.length() ? text.substring(0, guessNbChars) : text.substring(0, guessNbChars) + ELLIPSIS;
                currentCalculatedWidth = this.sizing.calculate(substr, font).getWidth();
            }
        }
        if (currentCalculatedWidth > maxWidth) {
            substr = text.substring(0, guessNbChars - 1) + ELLIPSIS;
        }
        return substr;
    }
}

