package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
/**
 * Fighting skill which is always visible.
 * @author César Infante, 2015
 * Created on Nov 2, 2015
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class FightingSkillAlwaysVisible extends Group implements IApplicableStyle {
    private StringProperty amount;
    private static final Image img = new Image(ClassLoader.getSystemResourceAsStream("icons/64/fightskill_icon.png"), 24, 24, true, true);

    public FightingSkillAlwaysVisible() {
        getStylesheets().add(this.getClass().getResource("icons.css").toExternalForm());
        amount = new SimpleStringProperty(this, "amount", "");

        final ImageView imageView = new ImageView(img);
        final Label text = new Label();
        text.getStyleClass().add("iconText");
        text.textProperty().bind(amount);
        imageView.layoutXProperty().bind(text.widthProperty().add(3));

        getChildren().addAll(text, imageView);
    }
    public void setAmount(Integer amount) {
        this.amount.set(String.valueOf(amount));
    }
    public int getAmount() {
        return Integer.parseInt(amount.get());
    }
    public StringProperty amountProperty() {
        return amount;
    }
    @Override
    public void applyStyle(String style) {
        for (Node node : getChildren()) {
            if (node instanceof IApplicableStyle) {
                ((IApplicableStyle)node).applyStyle(style);
            } else {
                node.setStyle(style);
            }
        }
    }
}
