package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

/**
 * Word splitter on any non alpha numeric characters.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 5, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class NonAlphaNumWordSplitter implements IWordSplitter {
	/**
	 * {@inheritDoc}<br>
	 * Split the word at every non alpha-numeric character except the "'".
	 * The delimiters are retained as part of the preceding word.
	 * <br>
	 * Note that if multiple delimiters succeed each other the second will be split into
	 * a separate word.
	 */
	@Override
	public String[] split(String word) {
		if (word.split("\\s").length != 1) {
			throw new IllegalArgumentException("The input consits on more than a single word.");
		}
		String regexPattern = "[^a-zA-Z0-9']"; // defining the pattern as set of what not to include
		return word.split("(?<="+regexPattern+")"); // using the Look-behind pattern
	}

}
