package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.OpenPatricianDialogInput;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;


/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 16, 2013
 */
public class OpenPatricianDialogInputSkin extends SkinBase<OpenPatricianDialogInput> {

    private DoubleProperty width = new SimpleDoubleProperty(this, "width", 0);
    private DoubleProperty height = new SimpleDoubleProperty(this, "height", 0);

    private TextSizingUtility sizing = new TextSizingUtility();
    private final TextField textField;

    public OpenPatricianDialogInputSkin(OpenPatricianDialogInput input) {
        super(input);

        textField = new TextField(input.getText());

        calculateDimensions(input);
        input.fontProperty().addListener((observable, oldValue, newValue) -> {
            calculateDimensions(input);
        });

        textField.textProperty().bindBidirectional(input.textProperty());
        textField.getStyleClass().add("openPatricianDialogInput");

        Rectangle background = new Rectangle();
        background.setHeight(height.doubleValue());
        background.setWidth(width.doubleValue());
        background.setFill(Color.rgb(150, 150, 150));
        background.heightProperty().bind(height);
        background.widthProperty().bind(width);


        StackPane stack = new StackPane();
        stack.getChildren().addAll(background, textField);
        Group group = new Group(stack);
        group.setManaged(false);

        getChildren().add(group);
    }

    private void calculateDimensions(OpenPatricianDialogInput input) {
        Dimension2D dim = sizing.calculate(input.getSize(), input.getFont());
        width.set(dim.getWidth());
        height.set(dim.getHeight() + 10);
        textField.setMaxSize(width.doubleValue(), height.doubleValue());
    }
}
