package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
/**
 * Change listener to change the label based on a boolean observable.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Aug 7, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
class PaginationLabelHoverChangeListener implements ChangeListener<Boolean> {

	private final Label label;
	

	public PaginationLabelHoverChangeListener(Label label) {
		super();
		this.label = label;
	}


	@Override
	public void changed(ObservableValue<? extends Boolean> observable,
			Boolean oldValue, Boolean newValue) {
		if (newValue) {
			label.getStyleClass().remove("pagination-label-unfocused");
			label.getStyleClass().add("pagination-label-focus");
		} else {
			label.getStyleClass().remove("pagination-label-focus");
			label.getStyleClass().add("pagination-label-unfocused");
		}
		
	}
	
}
