package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import lombok.Getter;
import lombok.Setter;

/**
 * Representing a single entry in the notice board menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@ClassCategory(EClassCategory.MODEL)
public class NoticeBoardMenuEntry {
    @Getter
    private DecoratedText label;
    @Setter
    @Getter
    private NoticeBoardMenu menu;
    private BooleanProperty disabled = new SimpleBooleanProperty(false);
    private BooleanProperty selected = new SimpleBooleanProperty(false);
    @Setter
    private int inset = 0;
    @Getter
    @Setter
    private EventHandler<MouseEvent> onMouseSelect;
    @Getter
    private final EDialogType dialogType;

    public NoticeBoardMenuEntry(EDialogType dialogType) {
        this.dialogType = dialogType;
    }

    public boolean getDisabled() {
        return disabled.get();
    }

    public BooleanProperty disabledProperty() {
        return disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled);
    }

    public boolean getSelected() {
        return selected.get();
    }

    public BooleanProperty selectedProperty() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public void setLabel(DecoratedText label) {
        this.label = label;
        this.label.setLayoutX(inset);
        label.setOnMouseReleased(evt -> {
            if (!getDisabled()) {
                menu.deselctAll();
                selected.setValue(true);
                if (onMouseSelect != null) {  // There might be simple messages that have no handle defined.
                    onMouseSelect.handle(evt);
                }
            }
        });
    }
}
