package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

/**
 * Data model to hold one entry of the OpenPatricianSpinner.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 02, 2016
 */
@ClassCategory({EClassCategory.JAVAFX, EClassCategory.MODEL})
public class OpenPatricianSpinnerOptionDataModel {
    private final String option;
    private final String value;
    private String display;

    public OpenPatricianSpinnerOptionDataModel(String option) {
        this(option, option);
    }

    public OpenPatricianSpinnerOptionDataModel(String option, String value) {
        this.option = option;
        this.value = value;
        this.display = option;
    }

    public String getOption() {
        return option;
    }

    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public boolean isEllipsed() {
        return !display.equals(option);
    }

    public String getValue() {
        return value;
    }
}
