package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Model of a table row.
 * On a row the constraint for the row height can be set.
 */
@ClassCategory(EClassCategory.MODEL)
public class TableRow implements Iterable<ITableCell>{
	@ListType(ITableCell.class)
	private List<ITableCell> cells;
	@MapType(key = ITableCell.class, value = ECellConstraint.class)
	private Map<ITableCell,ECellConstraint> contraints;
	private int heigth = 0;
	public TableRow() {
		cells = new ArrayList<>();
		contraints = new HashMap<>();
	}
	public ITableCell get(int index) {
		return cells.get(index);
	}
	public int size() {
		return cells.size();
	}
	public void add(ITableCell cell) {
		cells.add(cell);
	}
	public void add(ITableCell cell, ECellConstraint contraint) {
		add(cell);
		contraints.put(cell, contraint);
	}
	@Override
	public Iterator<ITableCell> iterator() {
		return cells.iterator();
	}
	
	public boolean hasConstraint(ITableCell cell) {
		return contraints.containsKey(cell);
	}
	public ECellConstraint getCellConstraint(ITableCell cell) {
		return contraints.get(cell);
	}

	public int getHeigth() {
		return heigth;
	}

	/**
	 * Set the constraint for the row height. Default value of 0 means no constraint.
	 * @param heigth
	 */
	public void setHeigth(int heigth) {
		this.heigth = heigth;
	}
}
