package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;

import java.util.LinkedHashSet;

/**
 * Providing the menu items for a notice board menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
public interface INoticeBoardMenuProvider {

    /**
     * Create a list of menu entries approypriate forthe type based on the city player proxy object.
     * @param proxy
     * @param type of the dialog in cas further distintion is needed.
     * @return
     */
    LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type);
}
