package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import java.util.LinkedHashSet;

/**
 * Notice board provider for the armory.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 *         Created on Jul 29, 2017
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardArmoryMenuProvider extends AbstractNoticeBoardMenuProvider implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<>();
        String s;
        if (type == ENoticeBoardType.ARMORY) {
            if (proxy.getPlayer().getRank() == ESocialRank.ALDERMAN || (proxy.getPlayer().getHometown().equals(proxy.getCity()) && proxy.getPlayer().getRank() == ESocialRank.MAYOR)) {
                s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.armory.handWeapon", new Object[]{}, locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.ARMORY_HAND_WEAPONS);
                entry.disabledProperty().setValue(true);
                entries.add(entry);
            }
            s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.armory.shipWeapon", new Object[]{}, locale.getCurrentLocal());
            NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.ARMORY_SHIP_WEAPONS);
            entries.add(entry);
        }
        return entries;
    }
}
