package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import java.util.LinkedHashSet;

/**
 * Provide menu items for the church notice board.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardChurchMenuProvider extends AbstractNoticeBoardMenuProvider implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<>();

        String s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.church.pray", new Object[]{}, locale.getCurrentLocal());
        NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.CHURCH_PRAY);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.church.feed", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.CHURCH_FEED);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.church.gift", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.CHURCH_GIFT);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.church.donation", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.CHURCH_EXTENSION);
        entries.add(entry);

        return entries;
    }

}
