package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenu;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.LinkedHashSet;

/**
 * Factory method to create the model for the notice board.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardMenuProvider {
    @Autowired
    private NoticeBoardMenuTitleProvider titleProvider;
    @Autowired
    private NoticeBoardMessageMenuProvider messageProvider;
    @Autowired
    private NoticeBoardChurchMenuProvider churchMenuProvider;
    @Autowired
    private NoticeBoardCityHallMenuProvider cityHallMenuProvider;
    @Autowired
    private NoticeBoardMarketPlaceMenuProvider marketPlaceMenuProvider;
    @Autowired
    private NoticeBoardTradingOfficeMenuProvider tradingOfficeMenuProvider;
    @Autowired
    private NoticeBoardTradingMenuProvider tradingMenuProvider;
    @Autowired
    private NoticeBoardTavernMenuProvider tavernMenuProvider;
    @Autowired
    private NoticeBoardLoanerMenuProvider loanerMenuProvider;
    @Autowired
    private NoticeBoardGuildMenuProvider guildMenuProvider;
    @Autowired
    private NoticeBoardShipSelectionMenuProvider shipSelectionMenuProvider;
    @Autowired
    private NoticeBoardShipyardMenuProvider shipyardMenuProvider;
    @Autowired
    private NoticeBoardArmoryMenuProvider armoryMenuProvider;

    public NoticeBoardMenu createMenu(ENoticeBoardType type, ICityPlayerProxyJFX proxy) {
        NoticeBoardMenu menu =  new NoticeBoardMenu(type);
        menu.setTitle(titleProvider.createTitle(type, proxy.getCity()));
        LinkedHashSet<NoticeBoardMenuEntry> entries = null;
        switch (type) {
            case MESSAGE:
                entries = messageProvider.createMenuEntries(proxy, type);
                break;
            case CHURCH:
                entries = churchMenuProvider.createMenuEntries(proxy, type);
                break;
            case CITY_HALL_ALDERMAN_OFFICE:
            case CITY_HALL_MAYORS_OFFICE:
            case CITY_HALL_MEETINGROOM:
            case CITY_HALL_NOTICE_BOARD:
                entries = cityHallMenuProvider.createMenuEntries(proxy, type);
                break;
            case LOANER:
                entries = loanerMenuProvider.createMenuEntries(proxy, type);
                break;
            case MARKET_PLACE:
                entries = marketPlaceMenuProvider.createMenuEntries(proxy, type);
                break;
            case SHIP_SELECTION:
                entries = shipSelectionMenuProvider.createMenuEntries(proxy, type);
                break;
            case SHIPYARD:
                entries = shipyardMenuProvider.createMenuEntries(proxy, type);
                break;
            case ARMORY:
                entries = armoryMenuProvider.createMenuEntries(proxy, type);
                break;
            case TAVERN:
                entries = tavernMenuProvider.createMenuEntries(proxy, type);
                break;
            case TRADING:
                entries = tradingMenuProvider.createMenuEntries(proxy, type);
                break;
            case TRADING_OFFICE:
                entries = tradingOfficeMenuProvider.createMenuEntries(proxy, type);
                break;
            case GUILD:
                entries = guildMenuProvider.createMenuEntries(proxy, type);
                break;
        }
        menu.setMenuEntries(entries);
        for (NoticeBoardMenuEntry entry : entries) {
            entry.setMenu(menu);
        }
        return menu;
    }
}
