package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import java.util.LinkedHashSet;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardTradingOfficeMenuProvider extends AbstractNoticeBoardMenuProvider implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<>();

        String s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.balanceSheet", new Object[]{}, locale.getCurrentLocal());
        NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.TO_BALANCE);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.PersonalDialog.personal", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.TO_PERSONAL);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.consumptionProduction", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.TO_CONSUMPTION_PRODUCTION);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.WeaponsDealerState.noticeboardTitle", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.TO_WEAPONS);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.warehouses", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.TO_WAREHOUSES);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.storageManager", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.TO_OFFICE_TRADING);
        entries.add(entry);

        return entries;
    }
}
