/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.bindings;

import ch.sahits.game.openpatrician.javafx.model.EClipAreaHorizontalScrollState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.scene.shape.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassCategory(value={EClassCategory.JAVAFX})
public class HorizontalScrollBinding
extends ObjectBinding<EClipAreaHorizontalScrollState> {
    private static final Logger log = LoggerFactory.getLogger(HorizontalScrollBinding.class);
    private final Rectangle clip;
    private double totalWidth;

    public HorizontalScrollBinding(Rectangle clip, double totalWidth) {
        this.clip = clip;
        this.totalWidth = totalWidth;
        super.bind(new Observable[]{clip.widthProperty(), clip.xProperty()});
    }

    protected EClipAreaHorizontalScrollState computeValue() {
        double clipWidth = this.clip.getWidth();
        if (clipWidth >= this.totalWidth) {
            log.trace("No scroll as clip width {} is larger than total width {}", (Object)clipWidth, (Object)this.totalWidth);
            return EClipAreaHorizontalScrollState.NO_SCROLL;
        }
        if (this.scrolledAllToTheLeft()) {
            log.trace("Scrolled all to the left when clip x == 0: {}", (Object)this.clip.getX());
            return EClipAreaHorizontalScrollState.ALL_LEFT;
        }
        if (this.scrolledAllToTheRight()) {
            log.trace("Scrolled all to the right when clip x is greater than the clip from the right: clip x = {}, totalWidth = {}, clip width = {}, clip left border {}", new Object[]{this.clip.getX(), this.totalWidth, this.clip.getWidth(), this.totalWidth - this.clip.getWidth()});
            return EClipAreaHorizontalScrollState.ALL_RIGHT;
        }
        log.trace("Scrollable in both directions: clip width={}, total width={}, clip x={}", new Object[]{clipWidth, this.totalWidth, this.clip.getX()});
        return EClipAreaHorizontalScrollState.CENTER;
    }

    public void setTotalWidth(double totalWidth) {
        this.totalWidth = totalWidth;
        this.invalidate();
    }

    private boolean scrolledAllToTheLeft() {
        return this.clip.getX() <= 0.0;
    }

    private boolean scrolledAllToTheRight() {
        return this.clip.getX() >= this.totalWidth - this.clip.getWidth();
    }
}

