/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.control.skin.CheatMenuSkin;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.net.URL;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.JAVAFX})
public class CheatMenu
extends Control {
    private final ICheatCommand cheat;
    private final ReadOnlyDoubleProperty parentWidth;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;

    public CheatMenu(ICheatCommand cheat, ReadOnlyDoubleProperty parentWidth) {
        this.parentWidth = parentWidth;
        this.cheat = cheat;
        this.getStyleClass().add((Object)"root");
    }

    public String getUserAgentStylesheet() {
        URL cssURL = ((Object)((Object)this)).getClass().getResource("/ch/sahits/game/openpatrician/javafx/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css");
        return cssURL.toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new CheatMenuSkin(this, this.parentWidth);
    }

    public String getDescription() {
        return this.messageSource.getMessage(this.cheat.getDescriptionTextKey(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getCancelLabel() {
        return this.messageSource.getMessage("cancel", new Object[0], this.locale.getCurrentLocal());
    }

    public String getOkLabel() {
        return this.messageSource.getMessage("ok", new Object[0], this.locale.getCurrentLocal());
    }

    public ICheatCommand getCheat() {
        return this.cheat;
    }
}

