/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.control.IItemNavigatorLabelWrapper;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassCategory(value={EClassCategory.JAVAFX})
public class ItemNavigator<T>
extends BorderPane {
    private static final Logger log = LoggerFactory.getLogger(ItemNavigator.class);
    private final ObservableList<IItemNavigatorLabelWrapper<T>> list = FXCollections.observableList(new ArrayList());
    private IntegerProperty currentPosition = new SimpleIntegerProperty(0);

    public ItemNavigator(List<IItemNavigatorLabelWrapper<T>> list) {
        this.list.setAll(list);
        this.initializeControl();
    }

    public int getCurrentPosition() {
        return this.currentPosition.get();
    }

    public IntegerProperty currentPositionProperty() {
        return this.currentPosition;
    }

    private void next() {
        try {
            if (this.currentPosition.get() == this.list.size() - 1) {
                this.currentPosition.setValue((Number)0);
            } else {
                this.currentPosition.setValue((Number)(this.currentPosition.get() + 1));
            }
        }
        catch (RuntimeException e) {
            log.error("Failed to switch to next item", (Throwable)e);
        }
    }

    private void previous() {
        try {
            if (this.currentPosition.get() == 0) {
                this.currentPosition.setValue((Number)(this.list.size() - 1));
            } else {
                this.currentPosition.setValue((Number)(this.currentPosition.get() - 1));
            }
        }
        catch (RuntimeException e) {
            log.error("Failed to switch to previous item", (Throwable)e);
        }
    }

    private void initializeControl() {
        if (!this.list.isEmpty()) {
            Text label = new Text(((IItemNavigatorLabelWrapper)this.list.get(this.getCurrentPosition())).getLabel());
            StringBinding labelBinding = new StringBinding(){

                protected String computeValue() {
                    return ((IItemNavigatorLabelWrapper)ItemNavigator.this.list.get(ItemNavigator.this.currentPosition.intValue())).getLabel();
                }
            };
            label.textProperty().bind((ObservableValue)labelBinding);
            label.getStyleClass().add((Object)"dialogText");
            label.setId("navigation-label");
            this.setCenter((Node)label);
            BooleanBinding visibleNavigation = new BooleanBinding(){

                protected boolean computeValue() {
                    return !ItemNavigator.this.list.isEmpty();
                }
            };
            OpenPatricianSmallWaxButton previous = new OpenPatricianSmallWaxButton("<");
            previous.setId("previous");
            previous.getStyleClass().add((Object)"actionButton");
            previous.setOnAction((EventHandler<MouseEvent>)((EventHandler)event -> this.previous()));
            previous.visibleProperty().bind((ObservableValue)visibleNavigation);
            this.setLeft((Node)previous);
            OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton(">");
            next.setId("next");
            next.getStyleClass().add((Object)"actionButton");
            next.setOnAction((EventHandler<MouseEvent>)((EventHandler)event -> this.next()));
            next.visibleProperty().bind((ObservableValue)visibleNavigation);
            this.setRight((Node)next);
        }
    }

    public T getCurrent() {
        return ((IItemNavigatorLabelWrapper)this.list.get(this.currentPosition.intValue())).getItem();
    }
}

