/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.control.NoticeBoardScrollPaneContent;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenu;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.LinkedList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;

public abstract class NoticeBoard
extends Group {
    public static final int DEFAULT_WIDTH = 216;
    private static final int DEFAULT_SCROLL_HEIGHT = 216;
    private static final int SCROLL_PANE_Y_LAYOUT = 11;
    private final NoticeBoardScrollPaneContent nbScrollPane;
    private final Group header;
    protected LinkedList<NoticeBoardMenu> noticeBoardMenu = new LinkedList();
    private final ScrollPane scrollPane;
    private boolean showNoticeBoardContent;

    public NoticeBoard() {
        this.setManaged(false);
        Object cssFileName = NoticeBoard.class.getSimpleName() + ".css";
        URL resource = NoticeBoard.class.getResource((String)cssFileName);
        this.getStylesheets().add((Object)resource.toExternalForm());
        cssFileName = "ScrollPane.css";
        resource = NoticeBoard.class.getResource((String)cssFileName);
        this.getStylesheets().add((Object)resource.toExternalForm());
        this.getStyleClass().add((Object)"noticeBoardText");
        this.header = new Group();
        this.header.setManaged(false);
        this.header.setId("header");
        this.scrollPane = new ScrollPane();
        this.scrollPane.setId("scrollPane");
        this.scrollPane.contentProperty().addListener((content, oldValue, newValue) -> System.out.println("Content of the scroll pane changed"));
        this.scrollPane.setLayoutX(20.0);
        this.scrollPane.setLayoutY(11.0);
        this.scrollPane.setMaxWidth(216.0);
        this.scrollPane.setMinWidth(216.0);
        this.scrollPane.setMaxHeight(216.0);
        this.scrollPane.setMinHeight(216.0);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.nbScrollPane = new NoticeBoardScrollPaneContent();
        this.nbScrollPane.setId("noticeBoardScrollPaneContent");
        this.resetScrollPane();
        this.getChildren().addAll((Object[])new Node[]{this.header, this.scrollPane});
    }

    public void addMenu(NoticeBoardMenu menu) {
        if (this.noticeBoardMenu.contains(menu)) {
            throw new IllegalArgumentException("The menu may not be added twice: " + menu);
        }
        this.noticeBoardMenu.add(menu);
        if (Platform.isFxApplicationThread()) {
            this.nbScrollPane.setContent(Optional.of(menu));
        } else {
            Platform.runLater(() -> this.nbScrollPane.setContent(Optional.of(menu)));
        }
    }

    protected void setHeader(Node headerContent) {
        this.header.getChildren().clear();
        this.header.getChildren().add((Object)headerContent);
    }

    protected void setScrollPaneContent(Node content) {
        double height = ((Region)this.header.getChildren().get(0)).getHeight();
        this.scrollPane.setLayoutY(height);
        ((Region)this.header.getChildren().get(0)).heightProperty().addListener((observable, oldValue, newValue) -> this.scrollPane.setLayoutY(newValue.doubleValue()));
        this.scrollPane.setMaxHeight(216.0 - height);
        this.scrollPane.setMinHeight(216.0 - height);
        this.scrollPane.setContent(content);
        this.showNoticeBoardContent = false;
    }

    protected void resetScrollPane() {
        this.scrollPane.setContent((Node)this.nbScrollPane);
        this.scrollPane.setLayoutY(11.0);
        this.scrollPane.setMaxHeight(216.0);
        this.scrollPane.setMinHeight(216.0);
        Platform.runLater(() -> this.header.getChildren().clear());
        this.showNoticeBoardContent = true;
    }

    public void closeNoticeBoard() {
        if (!this.noticeBoardMenu.isEmpty()) {
            this.noticeBoardMenu.removeLast();
        }
        Optional<Object> optMenu = this.noticeBoardMenu.isEmpty() ? Optional.empty() : Optional.of(this.noticeBoardMenu.getLast());
        if (Platform.isFxApplicationThread()) {
            this.nbScrollPane.setContent(optMenu);
        } else {
            Platform.runLater(() -> this.nbScrollPane.setContent(optMenu));
        }
    }

    public void reset(NoticeBoardMenu menu) {
        NoticeBoardMenu last = this.noticeBoardMenu.getLast();
        Preconditions.checkArgument((menu.getType() == last.getType() ? 1 : 0) != 0, (Object)"The displayed menu has a different type than the one to replace it with.");
        this.noticeBoardMenu.removeLast();
        this.addMenu(menu);
    }

    protected boolean isShowNoticeBoardContent() {
        return this.showNoticeBoardContent;
    }
}

