/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.javafx.control.skin.ShipIconSkin;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.net.URL;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipIcon
extends Control {
    private final INavigableVessel vessel;
    private final IHumanPlayer player;
    private final IDataImageLoader imageLoader;
    private ShipIconSkin skin;
    private BooleanProperty travelingEast = new SimpleBooleanProperty(false);
    private DoubleProperty scale = new SimpleDoubleProperty(1.0);

    public ShipIcon(INavigableVessel vessel, IHumanPlayer player, IDataImageLoader imageLoader) {
        this.vessel = vessel;
        this.imageLoader = imageLoader;
        this.player = player;
        this.setId(vessel.getUuid());
        this.createDefaultSkin();
    }

    public void updatePosition() {
        this.skin.updateShipPosition();
    }

    public void setTravelingEast(boolean travelingEast) {
        this.travelingEast.set(travelingEast);
    }

    public boolean isTravelingEast() {
        return this.travelingEast.get();
    }

    public BooleanProperty travelingEastProperty() {
        return this.travelingEast;
    }

    public double getScale() {
        return this.scale.get();
    }

    public DoubleProperty scaleProperty() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale.set(scale);
    }

    public INavigableVessel getVessel() {
        return this.vessel;
    }

    public IHumanPlayer getPlayer() {
        return this.player;
    }

    public String getUserAgentStylesheet() {
        URL cssURL = ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".css");
        return cssURL.toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        if (this.skin == null) {
            this.skin = new ShipIconSkin(this, this.imageLoader);
        }
        return this.skin;
    }
}

