/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.graphic.image.ITextSizing;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import javafx.geometry.Dimension2D;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TextSizingUtility
implements ITextSizing {
    double computeTextWidth(Font font, String text, double wrappingWidth) {
        Text helper = new Text();
        helper.setFont(font);
        helper.setText(text);
        helper.setWrappingWidth(0.0);
        helper.setLineSpacing(0.0);
        double w = Math.min(helper.prefWidth(-1.0), wrappingWidth);
        helper.setWrappingWidth((double)((int)Math.ceil(w)));
        return Math.ceil(helper.getLayoutBounds().getWidth());
    }

    double computeTextHeight(Font font, String text, double wrappingWidth) {
        return this.computeTextHeight(font, text, wrappingWidth, 0.0);
    }

    double computeTextHeight(Font font, String text, double wrappingWidth, double lineSpacing) {
        Text helper = new Text();
        helper.setFont(font);
        helper.setText(text);
        helper.setWrappingWidth((double)((int)wrappingWidth));
        helper.setLineSpacing(lineSpacing);
        return helper.getLayoutBounds().getHeight();
    }

    public Dimension2D calculate(int size, Font font) {
        double height = this.computeTextHeight(font, "Tg", Double.MAX_VALUE);
        double width = this.computeTextWidth(font, "n", Double.MAX_VALUE);
        return new Dimension2D(width * (double)size * 0.8, height * 1.2);
    }

    public int guessNumberOfCharacters(double destWidth, Font font) {
        double width = this.computeTextWidth(font, "n", Double.MAX_VALUE);
        return (int)Math.floor(destWidth / (width * 0.8));
    }

    public Dimension2D calculate(String text, Font font) {
        double height = this.computeTextHeight(font, text, Double.MAX_VALUE);
        double width = this.computeTextWidth(font, text, Double.MAX_VALUE);
        return new Dimension2D(width, height * 1.2);
    }
}

