/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

@ClassCategory(value={EClassCategory.JAVAFX})
public class TogglebleImageButton
extends ImageView {
    private final BooleanProperty active = new SimpleBooleanProperty(false);

    public TogglebleImageButton(Image inactiveImage, Image activeImage) {
        this.setImage(inactiveImage);
        this.active.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.setImage(activeImage);
            } else {
                this.setImage(inactiveImage);
            }
        });
    }

    public void toggle() {
        this.active.setValue(Boolean.valueOf(this.active.not().get()));
    }

    public boolean getActive() {
        return this.active.get();
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }
}

