/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.ChangeAmountButton;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.Timer;
import java.util.TimerTask;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;

@ClassCategory(value={EClassCategory.JAVAFX})
public class ChangeAmountButtonSkin
extends SkinBase<ChangeAmountButton> {
    private Timer timer = new Timer();
    private final ChangeAmountButton increaseButton;
    private OpenPatricianSmallWaxButton btn;

    public ChangeAmountButtonSkin(ChangeAmountButton control) {
        super((Control)control);
        this.increaseButton = control;
        this.initializeControl();
    }

    private void initializeControl() {
        this.btn = new OpenPatricianSmallWaxButton(this.increaseButton.getText());
        this.btn.textProperty().bind((ObservableValue)this.increaseButton.textProperty());
        this.btn.setOnMousePressed(evt -> {
            this.increaseButton.getOneClickAction().run();
            this.timer.schedule((TimerTask)new TimeScheduledInitialChange(), 2000L);
        });
        this.btn.setOnMouseReleased(evt -> {
            this.timer.cancel();
            this.timer.purge();
            this.timer = new Timer();
        });
        this.getChildren().add((Object)this.btn);
    }

    private class TimeScheduledInitialChange
    extends TimerTask {
        private TimeScheduledInitialChange() {
        }

        @Override
        public void run() {
            ChangeAmountButtonSkin.this.timer.scheduleAtFixedRate((TimerTask)new TimeScheduledChange(), 100L, 100L);
        }
    }

    private class TimeScheduledChange
    extends TimerTask {
        private TimeScheduledChange() {
        }

        @Override
        public void run() {
            ChangeAmountButtonSkin.this.increaseButton.getOneClickAction().run();
        }
    }
}

