/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.CheatMenu;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.openpatrician.javafx.model.OpenPatricianSpinnerOptionDataModel;
import ch.sahits.game.openpatrician.model.GenericTriple;
import ch.sahits.game.openpatrician.model.cheat.IDoubleSelectableCheatCommand;
import ch.sahits.game.openpatrician.model.cheat.ISingleSelectableCheatCommand;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

@ClassCategory(value={EClassCategory.JAVAFX})
public class CheatMenuSkin
extends SkinBase<CheatMenu> {
    private final CheatMenu control;

    public CheatMenuSkin(CheatMenu cheatMenu, ReadOnlyDoubleProperty parentWidth) {
        super((Control)cheatMenu);
        this.control = cheatMenu;
        Pane g = new Pane();
        g.setManaged(false);
        this.initializeControl(g, parentWidth);
        this.getChildren().add((Object)g);
    }

    private void initializeControl(Pane pane, ReadOnlyDoubleProperty parentWidth) {
        ObservableList options;
        OpenPatricianSpinner spinner;
        pane.maxWidthProperty().bind((ObservableValue)parentWidth.divide(2));
        Text desc = new Text(this.control.getDescription());
        desc.wrappingWidthProperty().bind((ObservableValue)parentWidth.divide(3));
        desc.setLayoutX(10.0);
        desc.setLayoutY(10.0);
        pane.getChildren().add((Object)desc);
        if (this.control.getCheat() instanceof ISingleSelectableCheatCommand) {
            spinner = new OpenPatricianSpinner();
            options = FXCollections.observableArrayList(this.getDescription(((ISingleSelectableCheatCommand)this.control.getCheat()).getOptions()));
            spinner.setOptions((ObservableList<OpenPatricianSpinnerOptionDataModel>)options);
            spinner.setMaxWidth(200.0);
            spinner.selectedIndexProperty().setValue((Number)0);
            spinner.setLayoutX(10.0);
            spinner.setLayoutY(100.0);
            pane.getChildren().add((Object)spinner);
        } else if (this.control.getCheat() instanceof IDoubleSelectableCheatCommand) {
            ((IDoubleSelectableCheatCommand)this.control.getCheat()).setupModel();
            spinner = new OpenPatricianSpinner();
            options = FXCollections.observableArrayList(this.getDescription(((IDoubleSelectableCheatCommand)this.control.getCheat()).getFirstOptions()));
            spinner.setOptions((ObservableList<OpenPatricianSpinnerOptionDataModel>)options);
            spinner.setMaxWidth(200.0);
            spinner.selectedIndexProperty().setValue((Number)0);
            spinner.setLayoutX(10.0);
            spinner.setLayoutY(100.0);
            pane.getChildren().add((Object)spinner);
            spinner = new OpenPatricianSpinner();
            options = FXCollections.observableArrayList(this.getDescription(((IDoubleSelectableCheatCommand)this.control.getCheat()).getSecondOptions()));
            spinner.setOptions((ObservableList<OpenPatricianSpinnerOptionDataModel>)options);
            spinner.setMaxWidth(200.0);
            spinner.selectedIndexProperty().setValue((Number)0);
            spinner.setLayoutX(10.0);
            spinner.setLayoutY(150.0);
            pane.getChildren().add((Object)spinner);
        }
        OpenPatricianStoneButton cancel = new OpenPatricianStoneButton(this.control.getCancelLabel());
        cancel.setOnAction((EventHandler<MouseEvent>)((EventHandler)event -> this.closeOverlay()));
        cancel.setLayoutX(10.0);
        cancel.setLayoutY(200.0);
        pane.getChildren().add((Object)cancel);
        OpenPatricianStoneButton ok = new OpenPatricianStoneButton(this.control.getOkLabel());
        ok.setOnAction((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.control.getCheat() instanceof IDoubleSelectableCheatCommand) {
                IDoubleSelectableCheatCommand cheat = (IDoubleSelectableCheatCommand)this.control.getCheat();
                OpenPatricianSpinner fistSpinner = (OpenPatricianSpinner)((Object)((Object)pane.getChildren().get(1)));
                OpenPatricianSpinner secondSpinner = (OpenPatricianSpinner)((Object)((Object)pane.getChildren().get(2)));
                cheat.setSelectedFirstOption((GenericTriple)cheat.getFirstOptions().get(fistSpinner.getSelectedIndex()));
                cheat.setSelectedSecondOption((GenericTriple)cheat.getSecondOptions().get(secondSpinner.getSelectedIndex()));
            } else if (this.control.getCheat() instanceof ISingleSelectableCheatCommand) {
                ISingleSelectableCheatCommand cheat = (ISingleSelectableCheatCommand)this.control.getCheat();
                OpenPatricianSpinner fistSpinner = (OpenPatricianSpinner)((Object)((Object)pane.getChildren().get(1)));
                cheat.setSelectedOption((GenericTriple)cheat.getOptions().get(fistSpinner.getSelectedIndex()));
            }
            this.control.getCheat().execute();
            this.closeOverlay();
        }));
        ok.setLayoutX(200.0);
        ok.setLayoutY(200.0);
        pane.getChildren().add((Object)ok);
    }

    private List<OpenPatricianSpinnerOptionDataModel> getDescription(List<GenericTriple<String>> options) {
        ArrayList<OpenPatricianSpinnerOptionDataModel> list = new ArrayList<OpenPatricianSpinnerOptionDataModel>();
        for (GenericTriple<String> option : options) {
            list.add(new OpenPatricianSpinnerOptionDataModel((String)option.getThird()));
        }
        return list;
    }

    private void closeOverlay() {
        ((Group)this.control.getParent()).getChildren().remove((Object)this.control);
    }
}

