/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.EventMediaPlayer;
import ch.sahits.game.openpatrician.javafx.control.EventPlayerFrame;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.io.InputStream;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassCategory(value={EClassCategory.JAVAFX})
public class EventMediaPlayerSkin
extends SkinBase<EventMediaPlayer> {
    private static final Logger log = LoggerFactory.getLogger(EventMediaPlayerSkin.class);
    private final EventMediaPlayer control;
    private TextSizingUtility textSize = new TextSizingUtility();

    public EventMediaPlayerSkin(EventMediaPlayer control, ReadOnlyDoubleProperty parentWidth) {
        super((Control)control);
        this.control = control;
        Group g = new Group();
        g.setManaged(false);
        this.initializeControl(g, parentWidth);
        this.getChildren().add((Object)g);
    }

    private void initializeControl(Group g, ReadOnlyDoubleProperty parentWidth) {
        EventPlayerFrame frame = new EventPlayerFrame(parentWidth);
        Dimension2D backgroundDim = frame.getBackgroundDimension();
        Point2D backgroundInset = frame.getInsetBackground();
        Rectangle background = new Rectangle(backgroundDim.getWidth(), backgroundDim.getHeight(), (Paint)Color.SADDLEBROWN);
        background.setLayoutX(backgroundInset.getX());
        background.setLayoutY(backgroundInset.getY());
        Label title = new Label(this.control.getTitle());
        title.getStyleClass().add((Object)"title");
        title.textProperty().bind((ObservableValue)this.control.titleProperty());
        Image titleImg = this.createImage("ParchmentTitleScroll.png");
        double titleWidth = titleImg.getWidth();
        ImageView titleBackground = new ImageView(titleImg);
        titleBackground.setLayoutX((frame.getWidth() - titleWidth) / 2.0);
        titleBackground.setLayoutY(35.0);
        title.setLayoutY(47.0);
        double scale = frame.getInnerDimension().getWidth() / 1920.0;
        Image descImg = this.createImage("parchment-background-1920x200.png");
        ImageView descBackground = new ImageView(descImg);
        descBackground.setFitWidth(frame.getInnerDimension().getWidth());
        double yPos = frame.getInsetMediaContent().getY() + frame.getInnerDimension().getHeight() - 200.0 * scale + 1.0;
        Text desc = new Text(this.control.getDescription());
        desc.getStyleClass().add((Object)"description");
        desc.setTextAlignment(TextAlignment.CENTER);
        desc.textProperty().bind((ObservableValue)this.control.descriptionProperty());
        desc.setWrappingWidth(frame.getInnerDimension().getWidth());
        StackPane stack = new StackPane(new Node[]{descBackground, desc});
        stack.setLayoutX(backgroundInset.getX());
        stack.setLayoutY(yPos);
        String resourcePath = this.control.getType().getResource();
        String sourcePath = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath).toExternalForm();
        log.debug("Load media file {} from {}", (Object)resourcePath, (Object)sourcePath);
        Media media = new Media(sourcePath);
        MediaPlayer player = new MediaPlayer(media);
        MediaView mediaView = new MediaView(player);
        mediaView.setPreserveRatio(true);
        mediaView.setFitWidth(frame.getInnerDimension().getWidth());
        mediaView.setLayoutX(frame.getInsetMediaContent().getX());
        mediaView.setLayoutY(frame.getInsetMediaContent().getY());
        player.setAutoPlay(true);
        this.setupErrorLogging(media, player, mediaView);
        g.getChildren().addAll((Object[])new Node[]{background, stack, mediaView, titleBackground, title, frame});
        Font openPatrician24 = Font.font((String)"OpenPatrician", (double)24.0);
        Font openPatrician18 = Font.font((String)"OpenPatrician", (double)18.0);
        frame.backgroundDimensionProperty().addListener((observable, oldValue, newValue) -> {
            background.setWidth(newValue.getWidth());
            background.setHeight(newValue.getHeight());
            Dimension2D titleDim = this.textSize.calculate(this.control.getTitle(), openPatrician24);
            title.setLayoutX((newValue.getWidth() - titleDim.getWidth()) / 2.0 + frame.getInsetBackground().getX());
            titleBackground.setLayoutX((newValue.getWidth() - titleWidth) / 2.0 + frame.getInsetBackground().getX() + 20.0);
        });
        frame.insetBackgroundProperty().addListener((observable, oldValue, newValue) -> {
            background.setLayoutX(newValue.getX());
            background.setLayoutY(newValue.getX());
            Dimension2D titleDim = this.textSize.calculate(this.control.getTitle(), openPatrician24);
            title.setLayoutX((frame.getBackgroundDimension().getWidth() - titleDim.getWidth()) / 2.0 + newValue.getX());
            titleBackground.setLayoutX((frame.getBackgroundDimension().getWidth() - titleWidth) / 2.0 + newValue.getX() + 20.0);
        });
        frame.innerDimensionProperty().addListener((observable, oldValue, newValue) -> {
            double localScale = newValue.getWidth() / 1920.0;
            double localYPos = frame.getInsetMediaContent().getY() + 1080.0 * localScale;
            stack.setLayoutY(localYPos);
            descBackground.setFitWidth(newValue.getWidth() + 4.0);
            descBackground.setFitHeight(newValue.getHeight() - 1080.0 * localScale + 2.0);
            Dimension2D descDimension = this.textSize.calculate(this.control.getDescription(), openPatrician18);
            double wrappingWidth = Math.min(descDimension.getWidth(), newValue.getWidth());
            desc.setWrappingWidth(wrappingWidth);
            mediaView.setFitWidth(newValue.getWidth() + 2.0);
            player.stop();
            player.play();
        });
        frame.insetMediaContentProperty().addListener((observable, oldValue, newValue) -> {
            stack.setLayoutX(frame.getInsetMediaContent().getX());
            double localScale = frame.getInnerDimension().getWidth() / 1920.0;
            double localYPos = newValue.getY() + 1080.0 * localScale;
            descBackground.setFitHeight(frame.getInnerDimension().getHeight() - 1080.0 * localScale + 2.0);
            stack.setLayoutY(localYPos);
            mediaView.setLayoutX(newValue.getX());
            mediaView.setLayoutY(newValue.getY());
            player.stop();
            player.play();
        });
        title.textProperty().addListener((observable, oldValue, newValue) -> {
            Dimension2D titleDim = this.textSize.calculate(this.control.getTitle(), openPatrician24);
            title.setLayoutX((frame.getBackgroundDimension().getWidth() - titleDim.getWidth()) / 2.0 + frame.getInsetBackground().getX());
        });
        desc.textProperty().addListener((observable, oldValue, newValue) -> {
            Dimension2D descDimension = this.textSize.calculate(this.control.getDescription(), openPatrician18);
            double wrappingWidth = Math.min(descDimension.getWidth(), frame.getInnerDimension().getWidth());
            desc.setWrappingWidth(wrappingWidth);
        });
        this.control.stoppedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                player.stop();
            }
        });
    }

    private void setupErrorLogging(Media media, MediaPlayer player, MediaView mediaView) {
        media.errorProperty().addListener((observable, oldValue, newValue) -> log.error("Error happened on media", (Throwable)newValue));
        player.errorProperty().addListener((observable, oldValue, newValue) -> log.error("Error happened on media player", (Throwable)newValue));
        media.setOnError(() -> log.error("Error happened on media"));
        player.setOnError(() -> log.error("Error happened on media player"));
        mediaView.setOnError(evt -> log.error("Error happened on media view:", (Throwable)evt.getMediaError()));
    }

    private Image createImage(String imgFileName) {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(imgFileName);
        return new Image(is);
    }
}

