/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.EventPlayerFrame;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

@ClassCategory(value={EClassCategory.JAVAFX})
public class EventPlayerFrameSkin
extends SkinBase<EventPlayerFrame> {
    private final int FRAME_BORDER_LENGTH = 128;
    private final double SCALE_FACTOR = 0.6;
    private final int FULL_INNER_HEIGTH = 1280;
    private final int FULL_INNER_WIDTH = 1920;
    private final int BORDER_THICKNESS = 30;
    private final int CORNER_OFFSET = 11;
    private final int INSET = 4;
    private final int INSET_CORNER_AFTER = 15;
    private final EventPlayerFrame control;

    public EventPlayerFrameSkin(EventPlayerFrame control) {
        super((Control)control);
        this.control = control;
        Group g = new Group();
        g.setManaged(false);
        this.initializeFrame(g);
        this.addResizeHandler(g);
        this.getChildren().add((Object)g);
    }

    private void addResizeHandler(Group g) {
        this.control.parentWidthProperty().addListener((observable, oldValue, newValue) -> {
            g.getChildren().clear();
            this.initializeFrame(g);
        });
    }

    private void initializeFrame(Group g) {
        int i;
        double targetWidth = this.calculateTargetWidth();
        int nbHorizElements = this.calculateNumberHorizontalElements(targetWidth);
        double innerWidthUnscaled = 22 + nbHorizElements * 128;
        Preconditions.checkArgument((innerWidthUnscaled >= targetWidth ? 1 : 0) != 0, (Object)("The unscaled width (" + innerWidthUnscaled + ") must be larger than the target width (" + targetWidth + ")"));
        double scale = targetWidth / innerWidthUnscaled;
        double innerWidthScaled = innerWidthUnscaled * scale;
        double innerHeigthScaled = this.calculateTargetHeigth(innerWidthScaled);
        int nbVertElements = this.calculateNumberVerticalElements(innerHeigthScaled);
        Image tl = this.createImage("DecoratedFrame-Corner-TL.png");
        Image tr = this.createImage("DecoratedFrame-Corner-TR.png");
        Image bl = this.createImage("DecoratedFrame-Corner-BL.png");
        Image br = this.createImage("DecoratedFrame-Corner-BR.png");
        Image top = this.createImage("DecoratedFrame-Top.png");
        Image left = this.createImage("DecoratedFrame-Left.png");
        Image right = this.createImage("DecoratedFrame-Right.png");
        Image bottom = this.createImage("DecoratedFrame-Bottom.png");
        double offsetX = 0.0;
        double offsetY = 0.0;
        ImageView imgView = this.createScaledView(tl, scale);
        double width = tl.getWidth() * scale;
        imgView.setLayoutX(offsetX);
        imgView.setLayoutY(offsetY);
        g.getChildren().addAll((Object[])new Node[]{imgView});
        offsetX += width - 15.0 * scale;
        for (int i2 = 0; i2 < nbHorizElements; ++i2) {
            imgView = this.createScaledView(top, scale);
            width = top.getWidth() * scale;
            imgView.setLayoutX(offsetX);
            imgView.setLayoutY(offsetY);
            g.getChildren().addAll((Object[])new Node[]{imgView});
            offsetX += width - 4.0 * scale;
        }
        double offsetRightBorder = offsetX -= 2.0;
        imgView = this.createScaledView(tr, scale);
        width = tr.getWidth() * scale;
        imgView.setLayoutX(offsetX);
        imgView.setLayoutY(offsetY);
        g.getChildren().addAll((Object[])new Node[]{imgView});
        offsetX = 0.0;
        offsetY += width - 15.0 * scale;
        for (i = 0; i < nbVertElements; ++i) {
            imgView = this.createScaledView(left, scale);
            double height = left.getHeight() * scale;
            imgView.setLayoutX(0.0);
            imgView.setLayoutY(offsetY);
            g.getChildren().addAll((Object[])new Node[]{imgView});
            imgView = this.createScaledView(right, scale);
            imgView.setLayoutX(offsetRightBorder);
            imgView.setLayoutY(offsetY);
            g.getChildren().addAll((Object[])new Node[]{imgView});
            offsetY += height - 4.0 * scale;
        }
        imgView = this.createScaledView(bl, scale);
        width = bl.getWidth() * scale;
        imgView.setLayoutX(offsetX);
        imgView.setLayoutY(offsetY -= 2.0);
        g.getChildren().addAll((Object[])new Node[]{imgView});
        offsetX += width - 15.0 * scale;
        for (i = 0; i < nbHorizElements; ++i) {
            imgView = this.createScaledView(bottom, scale);
            width = bottom.getWidth() * scale;
            imgView.setLayoutX(offsetX);
            imgView.setLayoutY(offsetY);
            g.getChildren().addAll((Object[])new Node[]{imgView});
            offsetX += width - 4.0 * scale;
        }
        imgView = this.createScaledView(br, scale);
        imgView.setLayoutX(offsetX -= 2.0);
        imgView.setLayoutY(offsetY);
        g.getChildren().addAll((Object[])new Node[]{imgView});
        Bounds frameBounds = g.getLayoutBounds();
        double borderInset = scale * 30.0;
        double backgroundInset = scale * 30.0 / 2.0;
        Dimension2D dim = new Dimension2D(frameBounds.getWidth() - 2.0 * borderInset, frameBounds.getHeight() - 2.0 * borderInset);
        ((ObjectProperty)this.control.innerDimensionProperty()).setValue((Object)dim);
        ((ObjectProperty)this.control.insetMediaContentProperty()).setValue((Object)new Point2D(borderInset, borderInset));
        ((ObjectProperty)this.control.insetBackgroundProperty()).setValue((Object)new Point2D(backgroundInset, backgroundInset));
        dim = new Dimension2D(frameBounds.getWidth() - 2.0 * backgroundInset, frameBounds.getHeight() - 2.0 * backgroundInset);
        ((ObjectProperty)this.control.backgroundDimensionProperty()).setValue((Object)dim);
    }

    private ImageView createScaledView(Image img, double scale) {
        ImageView view = new ImageView(img);
        view.setScaleX(scale);
        view.setScaleY(scale);
        return view;
    }

    private Image createImage(String imgFileName) {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(imgFileName);
        return new Image(is);
    }

    private double calculateTargetWidth() {
        double parentWidth = this.control.getParentWidth();
        return parentWidth * 0.6;
    }

    private int calculateNumberHorizontalElements(double targetWidth) {
        return (int)Math.max(Math.ceil((targetWidth - 22.0) / 128.0), 0.0);
    }

    private double calculateTargetHeigth(double targetWidth) {
        return targetWidth * 1280.0 / 1920.0;
    }

    private int calculateNumberVerticalElements(double targetHeigth) {
        return (int)Math.max(Math.ceil((targetHeigth - 22.0) / 128.0), 0.0);
    }
}

