/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.OpenPatricianHorizontalSelector;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianHorizontalSelectorSkin
extends SkinBase<OpenPatricianHorizontalSelector> {
    public OpenPatricianHorizontalSelectorSkin(OpenPatricianHorizontalSelector control) {
        super((Control)control);
        BorderPane pane = new BorderPane();
        OpenPatricianSmallWaxButton previous = new OpenPatricianSmallWaxButton("\u2190");
        previous.setId("previous");
        previous.setOnAction((EventHandler<MouseEvent>)((EventHandler)evt -> {
            if (control.getSelectedIndex() == 0) {
                control.selectedIndexProperty().setValue((Number)(control.valuesProperty().size() - 1));
            } else {
                control.selectedIndexProperty().setValue((Number)(control.getSelectedIndex() - 1));
            }
        }));
        OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton("\u2192");
        next.setId("next");
        next.setOnAction((EventHandler<MouseEvent>)((EventHandler)evt -> {
            if (control.getSelectedIndex() == control.valuesProperty().size() - 1) {
                control.selectedIndexProperty().setValue((Number)0);
            } else {
                control.selectedIndexProperty().setValue((Number)(control.getSelectedIndex() + 1));
            }
        }));
        Label label = new Label(control.getSelectedValue());
        label.setId("horizontalSelectorLabel");
        label.getStyleClass().add((Object)"dialogText");
        PlaceHolder placeHolder = new PlaceHolder(1.0, 1.0);
        StackPane center = new StackPane(new Node[]{placeHolder, label});
        control.parentWidh().addListener((observable, oldValue, newValue) -> {
            double left = previous.getWidth();
            double right = next.getWidth();
            placeHolder.setLocalWidth(newValue.doubleValue() + left + right);
        });
        control.selectedIndexProperty().addListener((observable, oldValue, newValue) -> label.setText(control.getSelectedValue()));
        pane.setLeft((Node)previous);
        pane.setRight((Node)next);
        pane.setCenter((Node)center);
        this.getChildren().add((Object)pane);
    }
}

