/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.ImageFactory;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianRadioButton;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.io.InputStream;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianRadioButtonSkin
extends SkinBase<OpenPatricianRadioButton> {
    private TextSizingUtility sizing = new TextSizingUtility();
    private ImageFactory imageFactory = new ImageFactory();
    private final ImageView slabView;
    private final Label label;

    public OpenPatricianRadioButtonSkin(OpenPatricianRadioButton radioButton) {
        super((Control)radioButton);
        String text = radioButton.getText();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("radioboxbg.png");
        Image rbBG = new Image(is);
        ImageView radioButtonView = new ImageView(rbBG);
        this.slabView = new ImageView();
        this.label = new Label(text);
        this.calculateNewDimenstions(radioButton, text, rbBG);
        radioButton.fontProperty().addListener((observable, oldValue, newValue) -> this.calculateNewDimenstions(radioButton, text, rbBG));
        this.label.getStyleClass().add((Object)"openPatricianRadioButton");
        Label selectedLabel = radioButton.isSelected() ? new Label(radioButton.getSelectedLabel()) : new Label(radioButton.getUnselectedLabel());
        selectedLabel.getStyleClass().add((Object)"openPatricianRadioButton-selection");
        selectedLabel.translateXProperty().set(20.0);
        selectedLabel.translateYProperty().set(32.0);
        radioButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                selectedLabel.setText(radioButton.getSelectedLabel());
            } else {
                selectedLabel.setText(radioButton.getUnselectedLabel());
            }
        });
        Group background = new Group(new Node[]{radioButtonView, this.slabView, this.label, selectedLabel});
        background.setOnMouseReleased(arg0 -> {
            boolean oldValue = radioButton.selectedProperty().get();
            if (!oldValue) {
                radioButton.setSelected(!oldValue);
            }
        });
        background.setManaged(false);
        this.getChildren().add((Object)background);
    }

    private void calculateNewDimenstions(OpenPatricianRadioButton radioButton, String text, Image rbBG) {
        int remainWidth = 28;
        int destHight = 27;
        double xStart = rbBG.getWidth();
        boolean yStart = false;
        Dimension2D dim = this.sizing.calculate(text, radioButton.getFont());
        double width = dim.getWidth();
        double destWidth = width - 28.0 + 10.0;
        String fileName = this.imageFactory.getFileNameExt(destWidth, 27.0, 28);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        Image slab = new Image(is, destWidth, 27.0, false, true);
        this.slabView.setImage(slab);
        this.slabView.translateXProperty().set(xStart);
        this.slabView.translateYProperty().set(0.0);
        double posX = destWidth / 2.0 + (xStart - 28.0 - 10.0);
        this.label.translateXProperty().set(posX);
    }
}

