/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSlider;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianSliderSkin
extends SkinBase<OpenPatricianSlider> {
    public static final int INITIAL_ROTATION = 10;
    DoubleProperty currentRotation;
    private TextSizingUtility sizeing;
    @ListType(value=Double.class)
    private List<Double> angles;
    private final int yTranslation = 15;
    private final OpenPatricianSlider control;

    public OpenPatricianSliderSkin(OpenPatricianSlider slider) {
        super((Control)slider);
        this.control = slider;
        this.currentRotation = new SimpleDoubleProperty((Object)this, "currentRotation", 10.0);
        this.sizeing = new TextSizingUtility();
        SteeringWheelGroup background = new SteeringWheelGroup(this.control.getInitialWidth(), this.currentRotation.doubleValue());
        background.setManaged(false);
        Group g = new Group(new Node[]{background});
        Point2D centerPoint = new Point2D((double)(this.control.getInitialWidth() / 2), (double)(this.control.getInitialWidth() / 2));
        this.createAndAddLabels(g, centerPoint);
        background.setTranslateX(centerPoint.getX() - (double)(background.getImageWidth() / 2));
        background.setTranslateY(centerPoint.getY() - (double)(background.getImageWidth() / 2) - 15.0);
        this.getChildren().add((Object)g);
    }

    private void createAndAddLabels(Group g, Point2D centerPoint) {
        ObservableList<String> values = this.control.valuesProperty();
        this.angles = new ArrayList<Double>(values.size());
        double angle = this.currentRotation.doubleValue() + 180.0;
        double step = (180.0 - 2.0 * this.currentRotation.doubleValue()) / (double)(values.size() - 1);
        int radius = 120;
        for (String value : values) {
            this.angles.add(angle);
            Point2D basePoint = this.calculateBasePoint(centerPoint, radius, angle);
            Dimension2D dim = this.sizeing.calculate(value, this.control.getFont());
            Label l = new Label(value);
            l.setFont(this.control.getFont());
            l.getStyleClass().add((Object)"openPatricianSlider");
            l.setTranslateX(basePoint.getX() - dim.getWidth() * this.calculateMoveFactor(angle));
            l.setTranslateY(basePoint.getY() - dim.getHeight());
            g.getChildren().add((Object)l);
            angle += step;
        }
        double initialAngle = Math.max(10.0, (double)this.control.getSelectedIndex() * step);
        this.currentRotation.setValue((Number)initialAngle);
    }

    void snapToNearestAngle() {
        double currentAngle = this.currentRotation.doubleValue() + 180.0;
        double currentMin = 360.0;
        int minIndex = 0;
        for (int i = 0; i < this.angles.size(); ++i) {
            double angle = this.angles.get(i);
            double diff = Math.abs(angle - currentAngle);
            if (!(diff < currentMin)) continue;
            currentMin = diff;
            minIndex = i;
        }
        Double destinationAngle = this.angles.get(minIndex);
        if (destinationAngle < 190.0 || destinationAngle > 350.0) {
            throw new IllegalStateException("Angle is out of range: " + this.currentRotation.doubleValue() + " -> " + destinationAngle);
        }
        this.control.selectedIndexProperty().set(minIndex);
        this.currentRotation.set(destinationAngle - 180.0);
    }

    double angleBetween2Lines(Point2D center, Point2D point) {
        double slope2 = this.calculateSlope(center, point);
        double angle = Math.atan(slope2);
        if (point.getX() > center.getX()) {
            angle = Math.PI - angle;
        }
        return Math.abs(Math.toDegrees(angle));
    }

    double calculateSlope(Point2D center, Point2D point) {
        double absSlope = Math.abs((point.getY() - center.getY()) / (point.getX() - center.getX()));
        if (point.getY() > center.getY()) {
            if (point.getX() > center.getX()) {
                return -absSlope;
            }
            return absSlope;
        }
        if (point.getX() > center.getX()) {
            return absSlope;
        }
        return -absSlope;
    }

    double calculateMoveFactor(double angle) {
        double deg = Math.toRadians(angle);
        return (Math.cos(deg - Math.PI) + 1.0) / 2.0;
    }

    Point2D calculateBasePoint(Point2D center, double radius, double angle) {
        float newX = (float)(center.getX() + radius * Math.cos(Math.toRadians(angle)));
        float newY = (float)(center.getY() + radius * Math.sin(Math.toRadians(angle)));
        return new Point2D((double)newX, (double)newY);
    }

    private class SteeringWheelGroup
    extends Group {
        public SteeringWheelGroup(int destinationWidth, double angle) {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("SteeringWheel.png");
            Image unscaled = new Image(is);
            double scale = (double)destinationWidth / unscaled.getWidth();
            ImageView steeringWheel = new ImageView(unscaled);
            steeringWheel.setScaleX(scale);
            steeringWheel.setScaleY(scale);
            steeringWheel.setRotate(angle);
            steeringWheel.rotateProperty().bind((ObservableValue)OpenPatricianSliderSkin.this.currentRotation);
            Group rotationGroup = new Group(new Node[]{steeringWheel});
            float gapCausedByScale = (this.getImageWidth() - destinationWidth) / 2;
            int radius = destinationWidth / 2;
            Rectangle clip = new Rectangle((double)gapCausedByScale, (double)gapCausedByScale, (double)destinationWidth, (double)radius);
            rotationGroup.setClip((Node)clip);
            Circle circle = new Circle((double)radius, (double)radius, (double)radius, (Paint)Color.RED);
            Circle innerCircle = new Circle((double)radius, (double)radius, (double)radius * 0.6);
            Line line = new Line(0.0, (double)radius, (double)destinationWidth, (double)radius);
            line.setStrokeWidth(10.0);
            line.setRotate(angle / 2.0);
            Shape finalShape = Shape.subtract((Shape)circle, (Shape)innerCircle);
            finalShape.setFill((Paint)Color.TRANSPARENT);
            finalShape.setTranslateX((double)gapCausedByScale);
            finalShape.setTranslateY((double)gapCausedByScale);
            finalShape.rotateProperty().bind((ObservableValue)OpenPatricianSliderSkin.this.currentRotation);
            finalShape.setOnMouseDragged(mouseEvent -> {
                Bounds bounds = OpenPatricianSliderSkin.this.control.getBoundsInParent();
                Point2D center = OpenPatricianSliderSkin.this.control.localToScene(bounds.getWidth() / 2.0, bounds.getHeight());
                if (mouseEvent.getSceneY() < center.getY()) {
                    Point2D draggedTo = new Point2D((double)((float)mouseEvent.getSceneX()), (double)((float)mouseEvent.getSceneY()));
                    double angle1 = OpenPatricianSliderSkin.this.angleBetween2Lines(center, draggedTo);
                    if (angle1 < 10.0) {
                        angle1 = 10.0;
                    }
                    if (angle1 > 170.0) {
                        angle1 = 170.0;
                    }
                    OpenPatricianSliderSkin.this.currentRotation.set(angle1);
                }
            });
            finalShape.setOnMouseReleased(event -> OpenPatricianSliderSkin.this.snapToNearestAngle());
            rotationGroup.getChildren().add((Object)finalShape);
            this.getChildren().add((Object)rotationGroup);
        }

        public final int getImageWidth() {
            return 479;
        }
    }
}

