/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.openpatrician.javafx.control.Line;
import ch.sahits.game.openpatrician.javafx.control.NonAlphaNumWordSplitter;
import ch.sahits.game.openpatrician.javafx.control.Page;
import ch.sahits.game.openpatrician.javafx.control.PageSplitter;
import ch.sahits.game.openpatrician.javafx.control.PaginationV2;
import ch.sahits.game.openpatrician.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.javafx.control.skin.PaginationLabelHoverChangeListener;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.model.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

@ClassCategory(value={EClassCategory.JAVAFX})
public class PaginationSkinV2
extends SkinBase<PaginationV2> {
    private static final double DROP_SHADOW_PADDING = 10.0;
    private final Label backLbl;
    private final Label nextLbl;
    private final VBox contentContainer;
    @ListType(value=Page.class)
    private final List<Page> pages;
    private int currentPage;
    private final DoubleProperty contentHeight;
    private final DoubleProperty contentWidth;
    private final BooleanProperty backButtonVisibility;
    private final BooleanProperty nextButtonVisibility;
    private final EventHandler<MouseEvent> backButtonEventHandler;
    private final EventHandler<MouseEvent> nextButtonEventHandler;
    private final PaginationV2 control;

    public PaginationSkinV2(PaginationV2 control) {
        super((Control)control);
        this.control = control;
        control.getStyleClass().add((Object)"paginationBG");
        this.pages = new ArrayList<Page>();
        this.currentPage = 0;
        this.backButtonVisibility = new SimpleBooleanProperty((Object)this, "backButtonVisibility", control.getFirstLastPageAction() != null);
        this.nextButtonVisibility = new SimpleBooleanProperty((Object)this, "nextButtonVisibility", true);
        this.backButtonEventHandler = new BackButtonEventHandler();
        this.nextButtonEventHandler = new NextButtonEventHanlder();
        Insets defaultInsets = new Insets(10.0);
        this.backLbl = new Label();
        this.backLbl.setId(((Object)((Object)this)).getClass().getName() + "backButton");
        this.backLbl.fontProperty().bind(control.navigationLabelFontProperty());
        this.backLbl.textProperty().bind((ObservableValue)control.backButtonLabelProperty());
        this.backLbl.visibleProperty().bind((ObservableValue)this.backButtonVisibility);
        this.backLbl.setPadding(defaultInsets);
        this.nextLbl = new Label();
        this.nextLbl.setId(((Object)((Object)this)).getClass().getName() + "nextButton");
        this.nextLbl.fontProperty().bind(control.navigationLabelFontProperty());
        this.nextLbl.textProperty().bind((ObservableValue)control.nextButtonLabelProperty());
        this.nextLbl.visibleProperty().bind((ObservableValue)this.nextButtonVisibility);
        this.nextLbl.setPadding(defaultInsets);
        this.contentContainer = new VBox();
        this.contentContainer.getStyleClass().add((Object)"containerVBox");
        this.contentContainer.setMaxWidth(control.getContentMaxWidth());
        this.contentContainer.setPadding(defaultInsets);
        this.contentHeight = new SimpleDoubleProperty((Object)this, "contentHeight", 0.0);
        this.contentHeight.bind((ObservableValue)control.contentMaxHeightProperty());
        this.contentWidth = new SimpleDoubleProperty((Object)this, "contentWidth", 0.0);
        DoubleBinding contentWidthBinding = control.contentMaxWidthProperty().subtract(((Insets)control.paddingLocalProperty().getValue()).getLeft()).subtract(((Insets)control.paddingLocalProperty().getValue()).getRight()).subtract(20.0);
        this.contentWidth.bind((ObservableValue)contentWidthBinding);
        control.paddingLocalProperty().addListener((observable, oldValue, newValue) -> {
            double sideInsets = newValue.getLeft() + newValue.getRight();
            this.contentWidth.set(control.contentMaxWidthProperty().subtract(sideInsets).doubleValue());
        });
        AnchorPane buttonRow = new AnchorPane();
        buttonRow.getChildren().addAll((Object[])new Node[]{this.backLbl, this.nextLbl});
        buttonRow.getStyleClass().add((Object)"buttonRow");
        AnchorPane.setLeftAnchor((Node)this.backLbl, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.nextLbl, (Double)control.getPaddingLocal().getRight());
        BorderPane overAllLayout = new BorderPane();
        PlaceHolder placeHolder = new PlaceHolder(1.0, this.contentHeight.doubleValue());
        placeHolder.heightLocalProperty().bind((ObservableValue)this.contentHeight);
        overAllLayout.setPadding(new Insets(10.0));
        overAllLayout.getStyleClass().add((Object)"overAllLayoutAnchorPane");
        overAllLayout.setLeft((Node)this.contentContainer);
        overAllLayout.setCenter((Node)placeHolder);
        overAllLayout.setBottom((Node)buttonRow);
        buttonRow.prefWidthProperty().bind((ObservableValue)overAllLayout.widthProperty());
        overAllLayout.maxWidthProperty().bind((ObservableValue)contentWidthBinding);
        this.initialalizeNewText(control.getText());
        Group group = new Group(new Node[]{overAllLayout});
        group.setManaged(false);
        group.setLayoutX(((Insets)control.paddingLocalProperty().getValue()).getLeft());
        this.getChildren().add((Object)group);
        PaginationLabelHoverChangeListener changeListenerBack = new PaginationLabelHoverChangeListener(this.backLbl);
        PaginationLabelHoverChangeListener changeListenerNext = new PaginationLabelHoverChangeListener(this.nextLbl);
        if (control.getBackButtonNode() != null && control.getNextButtonNode() != null) {
            control.getBackButtonNode().setOnMouseClicked(this.backButtonEventHandler);
            control.getNextButtonNode().setOnMouseClicked(this.nextButtonEventHandler);
            control.getBackButtonNode().hoverProperty().addListener((ChangeListener)changeListenerBack);
            control.getNextButtonNode().hoverProperty().addListener((ChangeListener)changeListenerNext);
        } else {
            this.nextLbl.setOnMouseClicked(this.nextButtonEventHandler);
            this.backLbl.setOnMouseClicked(this.backButtonEventHandler);
            this.backLbl.hoverProperty().addListener((ChangeListener)changeListenerBack);
            this.nextLbl.hoverProperty().addListener((ChangeListener)changeListenerNext);
        }
    }

    private void updateDisplay() {
        this.clearContents();
        Page page = this.pages.get(this.currentPage);
        for (Line line : page.getLines()) {
            Label l = new Label(line.getLine());
            l.getStyleClass().add((Object)line.getStyleClass());
            if (line.getStyleClass().equals("pagination-centered")) {
                l.setFont(this.control.getCenteredFont());
                BorderPane centered = new BorderPane();
                centered.setCenter((Node)l);
                this.contentContainer.getChildren().add((Object)centered);
                continue;
            }
            switch (line.getStyleClass()) {
                case "pagination-paragraph": {
                    l.setFont(this.control.getParagraphFont());
                    break;
                }
                case "pagination-heading": {
                    l.setFont(this.control.getHeaderFont());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown style for font setting");
                }
            }
            this.contentContainer.getChildren().add((Object)l);
        }
    }

    private void clearContents() {
        this.contentContainer.getChildren().removeAll((Collection)this.contentContainer.getChildren());
    }

    private void splitTextToPages(Text text) {
        double width = this.getContentWidth();
        double heigh = this.contentHeight.doubleValue();
        Font font = this.control.getNavigationLabelFont();
        PageSplitter splitter = new PageSplitter(heigh, width, this.contentContainer.getSpacing(), this.calculateContentInitialHeigth(), font);
        splitter.setWordSplitter(new NonAlphaNumWordSplitter());
        this.pages.addAll(splitter.splitIntoPages(text));
    }

    private double getContentWidth() {
        return this.contentWidth.get() - 20.0;
    }

    private double calculateContentInitialHeigth() {
        Insets insets = this.contentContainer.getInsets();
        double top = this.snapSpaceY(insets.getTop());
        double bottom = this.snapSpaceY(insets.getBottom());
        return top + bottom;
    }

    private void initialalizeNewText(Text text) {
        this.pages.clear();
        this.splitTextToPages(text);
        this.currentPage = 0;
        this.updateDisplay();
    }

    private class NextButtonEventHanlder
    implements EventHandler<MouseEvent> {
        private NextButtonEventHanlder() {
        }

        public void handle(MouseEvent event) {
            if (PaginationSkinV2.this.currentPage < PaginationSkinV2.this.pages.size() - 1) {
                ++PaginationSkinV2.this.currentPage;
                PaginationSkinV2.this.updateDisplay();
                PaginationSkinV2.this.backButtonVisibility.set(true);
                if (PaginationSkinV2.this.currentPage == PaginationSkinV2.this.pages.size() - 1 && PaginationSkinV2.this.control.getFirstLastPageAction() == null) {
                    PaginationSkinV2.this.nextButtonVisibility.set(false);
                }
            } else if (PaginationSkinV2.this.currentPage == PaginationSkinV2.this.pages.size() - 1) {
                PaginationSkinV2.this.control.getFirstLastPageAction().handle((Event)event);
            }
        }
    }

    private class BackButtonEventHandler
    implements EventHandler<MouseEvent> {
        private BackButtonEventHandler() {
        }

        public void handle(MouseEvent event) {
            if (PaginationSkinV2.this.currentPage > 0) {
                --PaginationSkinV2.this.currentPage;
                PaginationSkinV2.this.updateDisplay();
                PaginationSkinV2.this.nextButtonVisibility.set(true);
                if (PaginationSkinV2.this.currentPage == 0 && PaginationSkinV2.this.control.getFirstLastPageAction() == null) {
                    PaginationSkinV2.this.backButtonVisibility.set(false);
                }
            } else if (PaginationSkinV2.this.currentPage == 0) {
                PaginationSkinV2.this.control.getFirstLastPageAction().handle((Event)event);
            }
        }
    }
}

