/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.dialog;

import ch.sahits.game.openpatrician.javafx.dialog.IDialog;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.JAVAFX})
public class Dialog
extends Group
implements IDialog {
    @Autowired
    protected DecoratedTextFactory decoratedTextFactory;
    private final Group content;
    private EDialogType dialogType;

    public Dialog() {
        this.setManaged(false);
        this.getStylesheets().add((Object)Dialog.class.getResource("Dialog.css").toExternalForm());
        InputStream is = Dialog.class.getResourceAsStream("fringe.jpg");
        Image img = new Image(is);
        ImageView imgView = new ImageView(img);
        this.content = new Group();
        this.content.setId("content");
        this.getChildren().addAll((Object[])new Node[]{imgView, this.content});
    }

    public ObservableList<Node> getContent() {
        return this.content.getChildren();
    }

    public void replaceContent(Node ... nodes) {
        this.replaceContent(Arrays.asList(nodes));
    }

    public void replaceContent(List<Node> nodes) {
        this.content.getChildren().clear();
        this.content.getChildren().addAll(nodes);
    }

    public void close() {
    }

    public EDialogType getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(EDialogType dialogType) {
        this.dialogType = dialogType;
    }
}

