/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.MessageConfiguration;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class DisplayMessages {
    public static final int MESSAGE_STORE_SIZE = 50;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private MessageConfiguration messageConfiguration;
    @ListType(value=DisplayMessage.class)
    private SimpleListProperty<DisplayMessage> tradeMessages = new SimpleListProperty();
    @ListType(value=DisplayMessage.class)
    private SimpleListProperty<DisplayMessage> personalMessages = new SimpleListProperty();
    @ListType(value=DisplayMessage.class)
    private SimpleListProperty<DisplayMessage> officialMessages = new SimpleListProperty();

    public DisplayMessages() {
        this.tradeMessages.set(FXCollections.observableArrayList());
        this.personalMessages.set(FXCollections.observableArrayList());
        this.officialMessages.set(FXCollections.observableArrayList());
    }

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.clientServerEventBus.unregister((Object)this);
    }

    private boolean add(DisplayMessage element) {
        switch (element.getCategory()) {
            case TRADE: {
                if (this.tradeMessages.size() == this.messageConfiguration.getRetainedTradeMessages()) {
                    this.tradeMessages.remove(this.messageConfiguration.getRetainedTradeMessages() - 1);
                }
                this.tradeMessages.add(0, (Object)element);
                break;
            }
            case PERSONAL: {
                if (this.personalMessages.size() == this.messageConfiguration.getRetainedPersonalMessages()) {
                    this.personalMessages.remove(this.messageConfiguration.getRetainedPersonalMessages() - 1);
                }
                this.personalMessages.add(0, (Object)element);
                break;
            }
            case OFFICIAL: {
                if (this.officialMessages.size() == this.messageConfiguration.getRetainedOfficialMessages()) {
                    this.officialMessages.remove(this.messageConfiguration.getRetainedOfficialMessages() - 1);
                }
                this.officialMessages.add(0, (Object)element);
            }
        }
        return true;
    }

    @Subscribe
    public void handleMessage(DisplayMessage message) {
        this.add(message);
    }

    public ObservableList<DisplayMessage> tradeMessagesProperty() {
        return this.tradeMessages;
    }

    public ObservableList<DisplayMessage> personalMessagesProperty() {
        return this.personalMessages;
    }

    public ObservableList<DisplayMessage> officialMessagesProperty() {
        return this.officialMessages;
    }

    public void ensureMessagePoolSize() {
        while (this.tradeMessages.size() > this.messageConfiguration.getRetainedTradeMessages()) {
            this.tradeMessages.remove(this.messageConfiguration.getRetainedTradeMessages());
        }
        while (this.personalMessages.size() > this.messageConfiguration.getRetainedPersonalMessages()) {
            this.personalMessages.remove(this.messageConfiguration.getRetainedPersonalMessages());
        }
        while (this.officialMessages.size() > this.messageConfiguration.getRetainedOfficialMessages()) {
            this.officialMessages.remove(this.messageConfiguration.getRetainedOfficialMessages());
        }
    }
}

