/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.javafx.model.RowCellAlignement;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.HPos;

@ClassCategory(value={EClassCategory.MODEL})
public class Table
implements Iterable<TableRow> {
    private TableHeader header;
    @ListType(value=TableRow.class)
    private List<TableRow> rows = new ArrayList<TableRow>();
    private Integer[] columnWidth = new Integer[0];
    private RowCellAlignement alignment;

    public TableHeader getHeader() {
        return this.header;
    }

    public void setHeader(TableHeader header) {
        this.header = header;
        this.alignment = new RowCellAlignement(header.getNbCols());
    }

    public void add(TableRow row) {
        this.rows.add(row);
    }

    public TableRow get(int index) {
        return this.rows.get(index);
    }

    @Override
    public Iterator<TableRow> iterator() {
        return this.rows.iterator();
    }

    public int getNumberOfColumns() {
        return this.header != null ? this.header.getNbCols() : 0;
    }

    public int getNumberOfRows() {
        return this.rows.size();
    }

    public int getColumnWidth(int column) {
        if (column < this.columnWidth.length) {
            return this.columnWidth[column];
        }
        return 0;
    }

    public void setColumnWidth(Integer ... columnWidth) {
        this.columnWidth = columnWidth;
    }

    public void setAligenment(int index, HPos pos) {
        this.alignment.setAligenment(index, pos);
    }

    public HPos getAligenment(int column) {
        return this.alignment.getAligenment(column);
    }
}

