/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.javafx.control.MoneyTransfer;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.DynamicTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class JavaFXUtils {
    @Autowired
    private ApplicationContext context;

    public void addCellToGridPane(GridPane grid, int rowNum, TableRow row, int col, ITableCell cell, HPos hAlignment, String textStyleClass) {
        if (cell instanceof StaticTextTableCell) {
            Text text = new Text(((StaticTextTableCell)cell).getValue());
            text.getStyleClass().add((Object)textStyleClass);
            this.addCellToGridPane(rowNum, row, col, cell, (Node)text, grid, hAlignment);
        } else if (cell instanceof DynamicTextTableCell) {
            DynamicTextTableCell dynCell = (DynamicTextTableCell)cell;
            Text text = new Text();
            text.textProperty().bind((ObservableValue)dynCell.valueProperty());
            text.getStyleClass().add((Object)textStyleClass);
            this.addCellToGridPane(rowNum, row, col, cell, (Node)text, grid, hAlignment);
        } else if (cell instanceof ControlTableCell) {
            Node control = ((ControlTableCell)cell).getControl();
            this.addCellToGridPane(rowNum, row, col, cell, control, grid, hAlignment);
        } else {
            throw new RuntimeException("Not implemented");
        }
    }

    private void addCellToGridPane(int rowNum, TableRow row, int col, ITableCell cell, Node node, GridPane grid, HPos halignment) {
        if (row != null && row.hasConstraint(cell)) {
            switch (row.getCellConstraint(cell)) {
                case COLSPAN2: {
                    grid.add(node, col, rowNum + 1, 2, 1);
                    GridPane.setColumnSpan((Node)node, (Integer)2);
                    break;
                }
                case COLSPAN4: {
                    grid.add(node, col, rowNum + 1, 4, 1);
                    GridPane.setColumnSpan((Node)node, (Integer)4);
                    break;
                }
                default: {
                    grid.add(node, col, rowNum + 1);
                    break;
                }
            }
        } else {
            grid.add(node, col, rowNum + 1);
        }
        GridPane.setHalignment((Node)node, (HPos)halignment);
        GridPane.setValignment((Node)node, (VPos)VPos.CENTER);
    }

    public GridPane createGridPaneFromModel(Table model) {
        ITableCell cell;
        TableHeader header = model.getHeader();
        GridPane grid = new GridPane();
        RowConstraints rowConstraint = new RowConstraints(48.0);
        grid.getRowConstraints().add((Object)rowConstraint);
        rowConstraint = new RowConstraints(24.0);
        int[] mappedIndices = this.mapColIndices(header);
        int iterationLimit = Math.min(model.getNumberOfColumns(), header.size());
        for (int i = 0; i < iterationLimit; ++i) {
            int colWidth = model.getColumnWidth(i);
            ColumnConstraints colConstraint = new ColumnConstraints((double)colWidth);
            colConstraint.setHalignment(header.getAligenment(i));
            grid.getColumnConstraints().add((Object)colConstraint);
            cell = header.get(i);
            String textStyleClass = "tableHeader";
            int colIndex = mappedIndices[i];
            this.addCellToGridPane(grid, -1, header, colIndex, cell, header.getAligenment(i), "tableHeader");
        }
        for (int rowNum = 0; rowNum < model.getNumberOfRows(); ++rowNum) {
            TableRow row = model.get(rowNum);
            if (row.getHeigth() > 0) {
                grid.getRowConstraints().add((Object)new RowConstraints((double)row.getHeigth()));
            } else {
                grid.getRowConstraints().add((Object)rowConstraint);
            }
            iterationLimit = Math.min(model.getNumberOfColumns(), row.size());
            if (iterationLimit > 0) {
                mappedIndices = this.mapColIndices(row);
            }
            for (int col = 0; col < iterationLimit; ++col) {
                cell = row.get(col);
                HPos hAlignment = model.getAligenment(col);
                String textStyleClass = "tableCell";
                int colIndex = mappedIndices[col];
                this.addCellToGridPane(grid, rowNum, row, colIndex, cell, hAlignment, "tableCell");
            }
        }
        grid.setHgap(5.0);
        return grid;
    }

    private int[] mapColIndices(TableRow row) {
        int[] map = new int[row.size()];
        map[0] = 0;
        for (int i = 0; i < map.length - 1; ++i) {
            ITableCell cell = row.get(i);
            if (row.hasConstraint(cell)) {
                switch (row.getCellConstraint(cell)) {
                    case COLSPAN2: {
                        map[i + 1] = map[i] + 2;
                        break;
                    }
                    case COLSPAN4: {
                        map[i + 1] = map[i] + 4;
                    }
                }
                continue;
            }
            map[i + 1] = map[i] + 1;
        }
        return map;
    }

    public MoneyTransfer getMoneyTransfer(IDataImageLoader imageLoader) {
        return new MoneyTransfer(imageLoader);
    }
}

