/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenu;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardArmoryMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardChurchMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardCityHallMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardGuildMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardLoanerMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMarketPlaceMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMenuTitleProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMessageMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardShipyardMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardTavernMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardTradingMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardTradingOfficeMenuProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.LinkedHashSet;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardMenuProvider {
    @Autowired
    private NoticeBoardMenuTitleProvider titleProvider;
    @Autowired
    private NoticeBoardMessageMenuProvider messageProvider;
    @Autowired
    private NoticeBoardChurchMenuProvider churchMenuProvider;
    @Autowired
    private NoticeBoardCityHallMenuProvider cityHallMenuProvider;
    @Autowired
    private NoticeBoardMarketPlaceMenuProvider marketPlaceMenuProvider;
    @Autowired
    private NoticeBoardTradingOfficeMenuProvider tradingOfficeMenuProvider;
    @Autowired
    private NoticeBoardTradingMenuProvider tradingMenuProvider;
    @Autowired
    private NoticeBoardTavernMenuProvider tavernMenuProvider;
    @Autowired
    private NoticeBoardLoanerMenuProvider loanerMenuProvider;
    @Autowired
    private NoticeBoardGuildMenuProvider guildMenuProvider;
    @Autowired
    private NoticeBoardShipyardMenuProvider shipyardMenuProvider;
    @Autowired
    private NoticeBoardArmoryMenuProvider armoryMenuProvider;

    public NoticeBoardMenu createMenu(ENoticeBoardType type, ICityPlayerProxyJFX proxy) {
        NoticeBoardMenu menu = new NoticeBoardMenu(type);
        menu.setTitle(this.titleProvider.createTitle(type, proxy.getCity()));
        LinkedHashSet<NoticeBoardMenuEntry> entries = null;
        switch (type) {
            case MESSAGE_OFFICIAL: 
            case MESSAGE_PERSONAL: 
            case MESSAGE_TRADE: {
                entries = this.messageProvider.createMenuEntries(proxy, type);
                break;
            }
            case CHURCH: {
                entries = this.churchMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case CITY_HALL_ALDERMAN_OFFICE: 
            case CITY_HALL_MAYORS_OFFICE: 
            case CITY_HALL_MEETINGROOM: 
            case CITY_HALL_NOTICE_BOARD: {
                entries = this.cityHallMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case LOANER: {
                entries = this.loanerMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case MARKET_PLACE: {
                entries = this.marketPlaceMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case SHIPYARD: {
                entries = this.shipyardMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case ARMORY: {
                entries = this.armoryMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case TAVERN: {
                entries = this.tavernMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case TRADING: {
                entries = this.tradingMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case TRADING_OFFICE: {
                entries = this.tradingOfficeMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case GUILD: {
                entries = this.guildMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type " + type);
            }
        }
        menu.setMenuEntries(entries);
        for (NoticeBoardMenuEntry entry : entries) {
            entry.setMenu(menu);
        }
        return menu;
    }
}

