/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.javafx.model.DisplayMessages;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.TextEllipsisCalculator;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardMessageMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private DisplayMessages displayMessages;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TextEllipsisCalculator ellipsisCalculator;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private TextSizingUtility sizeing;
    @Autowired
    private ApplicationContext context;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        EMessageCategory messageCategory = this.map(type);
        ObservableList<DisplayMessage> messages = this.getDisplayMessages(messageCategory);
        double maxWidth = 186.0;
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        for (DisplayMessage message : messages) {
            EventHandler openDialogEvenHandler;
            Runnable runnable;
            Object[] args = message.getMessageArguments();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof EWare)) continue;
                args[i] = this.translator.getLocalDisplayName((IWare)((EWare)args[i]));
            }
            String translatedMessage = this.messageSource.getMessage(message.getMessageKey(), args, this.locale.getCurrentLocal());
            DecoratedText text = new DecoratedText();
            String messageString = this.ellipsisCalculator.calculateEllipsis(text.getFont(), translatedMessage, maxWidth);
            text = this.textFactory.createSimpleDecoratedText(messageString);
            EventHandler<MouseEvent> onMouseFocus = this.getDisplaMessageMouseEnterFocusEventHandler(text, translatedMessage);
            EventHandler<MouseEvent> onMouseExitFocus = this.getDisplayMessageMouseExitFocusEventHandler(text);
            text.setOnMouseEntered(onMouseFocus);
            text.setOnMouseExited(onMouseExitFocus);
            NoticeBoardMenuEntry entry = new NoticeBoardMenuEntry(null);
            entry.setLabel(text);
            if (message instanceof DisplayTemplateMessage) {
                args = new Object[]{((DisplayTemplateMessage)message).getDialogTemplate()};
                runnable = (Runnable)this.context.getBean("viewChangeDialogTemplateRunnable", args);
                openDialogEvenHandler = evt -> runnable.run();
                entry.setOnMouseSelect((EventHandler<MouseEvent>)openDialogEvenHandler);
            }
            if (message instanceof DisplayStateMessage) {
                args = new Object[]{((DisplayStateMessage)message).getState()};
                runnable = (Runnable)this.context.getBean("viewChangeDialogStateRunnable", args);
                openDialogEvenHandler = evt -> runnable.run();
                entry.setOnMouseSelect((EventHandler<MouseEvent>)openDialogEvenHandler);
            }
            entries.add(entry);
        }
        return entries;
    }

    private ObservableList<DisplayMessage> getDisplayMessages(EMessageCategory messageCategory) {
        switch (messageCategory) {
            case TRADE: {
                return this.displayMessages.tradeMessagesProperty();
            }
            case PERSONAL: {
                return this.displayMessages.personalMessagesProperty();
            }
            case OFFICIAL: {
                return this.displayMessages.officialMessagesProperty();
            }
        }
        return null;
    }

    private EMessageCategory map(ENoticeBoardType type) {
        switch (type) {
            case MESSAGE_OFFICIAL: {
                return EMessageCategory.OFFICIAL;
            }
            case MESSAGE_PERSONAL: {
                return EMessageCategory.PERSONAL;
            }
            case MESSAGE_TRADE: {
                return EMessageCategory.TRADE;
            }
        }
        return null;
    }

    private EventHandler<MouseEvent> getDisplaMessageMouseEnterFocusEventHandler(DecoratedText text, String message) {
        return event -> {
            Group viewContainer = (Group)((StackPane)text.getScene().getRoot()).getChildren().get(1);
            DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(message, this.sizeing);
            double y = event.getSceneY();
            label.setLayoutY(y);
            label.setLayoutX(350.0);
            viewContainer.getChildren().add((Object)label);
        };
    }

    private EventHandler<MouseEvent> getDisplayMessageMouseExitFocusEventHandler(DecoratedText text) {
        return event -> {
            Group viewContainer = (Group)((StackPane)text.getScene().getRoot()).getChildren().get(1);
            Iterator iterator = viewContainer.getChildren().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof DisplayMessageOverlayLabel)) continue;
                iterator.remove();
                break;
            }
        };
    }
}

