package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import ch.sahits.game.openpatrician.model.time.DateObject;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
/**
 * Implementation of an artificial intelligence player.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 17, 2011
 *
 */
class AIPlayer extends Player implements IAIPlayer {
	
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

	public AIPlayer(ICity homeTown,long cash, DateObject birthDate) {
		super(homeTown, getPersonalData(homeTown, birthDate),cash,ESocialRank.BARGAINER);
	}

	private static PersonalData getPersonalData(ICity homeTown, DateObject birthDate) {
		return new PersonalData(getRandomFirstName(), getRandomLastName(), true, homeTown, birthDate);
	}

	private static String getRandomFirstName(){
		return firstNameLoader.getRandomName();
	}
	private static String getRandomLastName(){
		return lastNameLoader.getRandomName();
	}
}
