package ch.sahits.game.openpatrician.model;
/**
 * This base class for amountable items provides a count of the items.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 * @param <T>
 */
public class BaseAmountable<T extends IAmountable> {
	/** Number of items that are amounted */
	protected int amount=0;
	/**
	 * Retrieve the number of items
	 * @return
	 */
	public int getAmount(){
		return amount;
	}
	/**
	 * Add a number items
	 * @param amount number of the items to be added
	 * @param avgPrice average price of one item that is added
	 */
	public void add(int amount){
		if (amount<0){
			amount = Math.abs(amount);
		}
		this.amount += amount;
	}
	/**
	 * Remove a number of items
	 * @param amount of items to be removed
	 */
	public void remove (int amount){
		if (amount<0){
			amount = Math.abs(amount);
		}
		if (amount==Integer.MIN_VALUE){
			amount = Integer.MAX_VALUE;
		}
		if (this.amount<amount){
			this.amount=0;
		} else {
			this.amount -= amount;
		}
	}
	public String toString(){
		return String.valueOf(amount);
	}
}
