package ch.sahits.game.openpatrician.model;
/**
 * Defining the difficulty in the game
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 12, 2011
 *
 */
public final class Difficulty {
	
	public final static Difficulty CHANDLER = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, 30000, 2);
	public final static Difficulty MERCHANT = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 2);
	public final static Difficulty TRADESMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 1);
	public final static Difficulty COUNSILMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1);
	public final static Difficulty PATRICIAN= new Difficulty(EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1);;
	/** 
	 * Difficulty trade: at higher settings the buying prices are 
	 * higher and the selling prices, thus reducing the margin of profit 
	 */
	private final EDifficultyLevel trade;
	/** Difficulty approval: at higher settings for every action that increases
	 * the approval rating a malus is taken into account. The approval rating thus
	 * rises more slowly.
	 */
	private final EDifficultyLevel approval;
	/**
	 * Need of civilians: at higher levels the citicens are more easily unhappy when certain
	 * wares are missing.
	 */
	private final EDifficultyLevel need;
	/**
	 * Naval battle strength: at higher levels the opponents navigate more intelligent.
	 */
	private final EDifficultyLevel navalBattle;
	/**
	 * Pirate activity: at higher levels there are more pirates that are more havily armed.
	 */
	private final EDifficultyLevel pirateActivity;
	/**
	 * Activity of the sovereign: at higher levels the sovereign uses larger armies and sieges do
	 * happen more often.
	 */
	private final EDifficultyLevel sovereignActivity;
	/**
	 * starting capital
	 */
	private final int startingCapital;
	/**
	 * Number of starting ships
	 */
	private final int numberOfShips;
	public EDifficultyLevel getTrade() {
		return trade;
	}
	public EDifficultyLevel getApproval() {
		return approval;
	}
	public EDifficultyLevel getNeed() {
		return need;
	}
	public EDifficultyLevel getNavalBattle() {
		return navalBattle;
	}
	public EDifficultyLevel getPirateActivity() {
		return pirateActivity;
	}
	public EDifficultyLevel getSovereignActivity() {
		return sovereignActivity;
	}
	public int getStartingCapital() {
		return startingCapital;
	}
	public int getNumberOfShips() {
		return numberOfShips;
	}
	public Difficulty(EDifficultyLevel trade, EDifficultyLevel approval,
			EDifficultyLevel need, EDifficultyLevel navalBattle,
			EDifficultyLevel pirateActivity,
			EDifficultyLevel sovereignActivity, int startingCapital,
			int numberOfShips) {
		super();
		this.trade = trade;
		this.approval = approval;
		this.need = need;
		this.navalBattle = navalBattle;
		this.pirateActivity = pirateActivity;
		this.sovereignActivity = sovereignActivity;
		this.startingCapital = startingCapital;
		this.numberOfShips = numberOfShips;
	}
	
}
