package ch.sahits.game.openpatrician.model;

import ch.sahits.game.event.Event;
import ch.sahits.game.event.IEventListener;
/**
 * Implementation of the game
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 16, 2011
 *
 */
class Game implements IGame, IEventListener {
	
	private final IMap map;
	@SuppressWarnings("unused")
	private final EObjective objective;
	private final Difficulty difficulty;
	private EGameSpeed speed;
	private Date gameTime;

	
	public Game(IMap map, EObjective objective,
			Difficulty difficulty, EGameSpeed speed, Date gameTime) {
		super();
		this.map = map;
		this.objective = objective;
		this.difficulty = difficulty;
		this.speed = speed;
		this.gameTime = gameTime;
	}

	@Override
	public IMap getMap() {
		return map;
	}

	@Override
	public boolean isObjectivReached() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setGameSpeed(EGameSpeed speed) {
		this.speed=speed;
	}

	@Override
	public EGameSpeed getGameSpeed() {
		return speed;
	}

	@Override
	public Difficulty getDifficulty() {
		return difficulty;
	}

	@Override
	public Date getTime() {
		return gameTime;
	}

	@Override
	public void gameUpdate(Event e, Object eventNotice) {
		// TODO Clock tick events to update the time
		
	}

}
